% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randtest.hist.R
\name{randtest.hist}
\alias{randtest.hist}
\title{Function to create a histogram of results from the randomization test tool
(\code{randtest}) in \href{https://uupharmacometrics.github.io/PsN/}{PsN}}
\usage{
randtest.hist(
  results.file = "raw_results_run1.csv",
  df = 1,
  p.val = 0.05,
  main = "Default",
  xlim = NULL,
  PCTSlcol = "black",
  vlcol = c("red", "orange"),
  ...
)
}
\arguments{
\item{results.file}{The location of the results file from the
\code{randtest} tool in \href{https://uupharmacometrics.github.io/PsN/}{PsN}}

\item{df}{The degrees of freedom between the full and reduced model used in
the randomization test.}

\item{p.val}{The p-value you would like to use.}

\item{main}{The title of the plot.}

\item{xlim}{The limits of the x-axis}

\item{PCTSlcol}{Color of the empirical line}

\item{vlcol}{Colors of the original and nominal line}

\item{\dots}{Additional arguments that can be passed to
\link{xpose.plot.histogram}, \link{xpose.panel.histogram},
\link[lattice]{histogram} and other \link[lattice]{lattice-package}
functions.}
}
\value{
A lattice object
}
\description{
Reads results from the \code{randtest} tool in \href{https://uupharmacometrics.github.io/PsN/}{PsN}
and then creates a histogram.
}
\examples{

\dontrun{
randtest.hist(results.file="randtest_dir1/raw_results_run1.csv",df=2)
}

}
\references{
\href{https://uupharmacometrics.github.io/PsN/}{PsN}
}
\seealso{
\link{xpose.plot.histogram}, \link{xpose.panel.histogram},
\link[lattice]{histogram} and other \link[lattice]{lattice-package}
functions.

Other PsN functions: 
\code{\link{boot.hist}()},
\code{\link{bootscm.import}()},
\code{\link{npc.coverage}()},
\code{\link{read.npc.vpc.results}()},
\code{\link{read.vpctab}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose4-package}}
}
\author{
Andrew Hooker
}
\concept{PsN functions}
\keyword{methods}
