# Xpose 4
# An R-based population pharmacokinetic/
# pharmacodynamic model building aid for NONMEM.
# Copyright (C) 1998-2004 E. Niclas Jonsson and Mats Karlsson.
# Copyright (C) 2005-2008 Andrew C. Hooker, Justin J. Wilkins, 
# Mats O. Karlsson and E. Niclas Jonsson.
# Copyright (C) 2009-2010 Andrew C. Hooker, Mats O. Karlsson and 
# E. Niclas Jonsson.

# This file is a part of Xpose 4.
# Xpose 4 is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation, either version 3
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.

# You should have received a copy of the GNU Lesser General Public License
# along with this program.  A copy can be cound in the R installation
# directory under \share\licenses. If not, see http://www.gnu.org/licenses/.

"basic.model.comp" <- function(object, 
                               object.ref = NULL,
                               onlyfirst = FALSE,
                               inclZeroWRES = FALSE,
                               subset = xsubset(object),
                               #prompt = TRUE,
                               main="Default",
                               force.wres=FALSE,
                               ...) {

  if (is.null(object.ref)) {
    ref.list <- get.refrunno()
    object.ref <- .ref.db
    if(any(is.null(ref.list)))
      return()
  } 
  
  if(dim(object@Data)[1] != dim(object.ref@Data)[1]) {
    cat("The current database and the reference database do not have\n")
    cat("the same number of lines!\n")
    invisible()
    return()
  }


  if(is.null(check.vars(c("idlab","pred","ipred","iwres"),
                        object,silent=FALSE))) {      
    return()
  }

  use.cwres=TRUE
  if(force.wres){
    use.cwres=FALSE
    if(is.null(check.vars(c("wres"),object,silent=FALSE))) return()
  } else {
    if(is.null(check.vars(c("cwres"),object,silent=TRUE))) {
      use.cwres=FALSE
      if(is.null(check.vars(c("wres"),object,silent=FALSE))) return()
    }
  }

  
  object@Data$PRED.REF <- object.ref@Data[,xvardef("pred", object.ref)]
  object@Data$IPRED.REF <- object.ref@Data[,xvardef("ipred", object.ref)]
  if(use.cwres){
    object@Data$CWRES.REF <- object.ref@Data[,xvardef("cwres", object.ref)]
  } else {
    object@Data$WRES.REF <- object.ref@Data[,xvardef("wres", object.ref)]
  }
  
  object@Data$IWRES.REF <- object.ref@Data[,xvardef("iwres", object.ref)]
  
  
  ## PRED vs PRED
  if(!any(is.null(xvardef("pred", object))) && !any(is.null(xvardef("pred", object.ref)))) {
    xlb <- paste(xlabel(xvardef("pred",object),object), " (Run ", object@Runno, ")",sep="")
    ylb <- paste(xlabel(xvardef("pred",object.ref),object.ref), " (Run ", object.ref@Runno, ")",sep="")
    main <- paste(ylb, " vs ", xlb, sep="")
   
    xplot1 <- xpose.plot.default(xvardef("pred", object),
                        "PRED.REF",
                        object,
                        xlb = xlb,
                        ylb = ylb,
                        main = NULL,
                        abline=c(0,1),
                        onlyfirst = onlyfirst,
                        inclZeroWRES = inclZeroWRES,
                        subset = subset,
                        ...)
    
  }

                                        # IPRED vs IPRED
  if(!any(is.null(xvardef("ipred", object))) && !any(is.null(xvardef("ipred", object.ref)))) {
    xlb <- paste(xlabel(xvardef("ipred",object),object), " (Run ", object@Runno, ")",sep="")
    ylb <- paste(xlabel(xvardef("ipred",object.ref),object.ref), " (Run ", object.ref@Runno, ")",sep="")
    main <- paste(ylb, " vs ", xlb, sep="")
   
    xplot2 <- xpose.plot.default(xvardef("ipred", object),
                        "IPRED.REF",
                        object,
                        xlb = xlb,
                        ylb = ylb,
                        main = NULL,
                        abline=c(0,1),
                        onlyfirst = onlyfirst,
                        inclZeroWRES = inclZeroWRES,
                        subset = subset,
                        ...)
    
  }

  if(use.cwres){
    ## CWRES vs CWRES
    if(!any(is.null(xvardef("cwres", object))) && !any(is.null(xvardef("cwres", object.ref)))) {
      xlb <- paste(xlabel(xvardef("cwres",object),object), " (Run ", object@Runno, ")",sep="")
      ylb <- paste(xlabel(xvardef("cwres",object.ref),object.ref), " (Run ", object.ref@Runno, ")",sep="")
      main <- paste(ylb, " vs ", xlb, sep="")
      
      xplot3 <- xpose.plot.default(xvardef("cwres", object),
                                   "CWRES.REF",
                                   object,
                                   xlb = xlb,
                                   ylb = ylb,
                                   main = NULL,
                                   abline=c(0,1),
                                   onlyfirst = onlyfirst,
                                   inclZeroWRES = inclZeroWRES,
                                   subset = subset,
                                   ...) 
      
    }
  } else {
    ## WRES vs WRES
    if(!any(is.null(xvardef("wres", object))) && !any(is.null(xvardef("wres", object.ref)))) {
      xlb <- paste(xlabel(xvardef("wres",object),object), " (Run ", object@Runno, ")",sep="")
      ylb <- paste(xlabel(xvardef("wres",object.ref),object.ref), " (Run ", object.ref@Runno, ")",sep="")
      main <- paste(ylb, " vs ", xlb, sep="")
      
      xplot3 <- xpose.plot.default(xvardef("wres", object),
                                   "WRES.REF",
                                   object,
                                   xlb = xlb,
                                   ylb = ylb,
                                   main = NULL,
                                   abline=c(0,1),
                                   onlyfirst = onlyfirst,
                                   inclZeroWRES = inclZeroWRES,
                                   subset = subset,
                                   ...) 
      
    }
  }
          
  # IWRES vs IWRES
  if(!any(is.null(xvardef("iwres", object))) && !any(is.null(xvardef("iwres", object.ref)))) {
    xlb <- paste(xlabel(xvardef("iwres",object),object), " (Run ", object@Runno, ")",sep="")
    ylb <- paste(xlabel(xvardef("iwres",object.ref),object.ref), " (Run ", object.ref@Runno, ")",sep="")
    main <- paste(ylb, " vs ", xlb, sep="")
   
    xplot4 <- xpose.plot.default(xvardef("iwres", object),
                        "IWRES.REF",
                        object,
                        xlb = xlb,
                        ylb = ylb,
                        main = NULL,
                        abline=c(0,1),
                        onlyfirst = onlyfirst,
                        inclZeroWRES = inclZeroWRES,
                        subset = subset,
                        ...) 
  }
    ## create enpty list for plots
    num.of.plots <- 4
    plotList <- vector("list",num.of.plots)

    plotList[[1]] <- xplot1
    plotList[[2]] <- xplot2
    plotList[[3]] <- xplot3
    plotList[[4]] <- xplot4      

        
    
    default.plot.title <- "Basic model comparison plots"
    plotTitle <- xpose.multiple.plot.title(object=object,
                                           plot.text = default.plot.title,
                                           subset=subset,
                                           main=main,
                                           ...)
  
    
    obj <- xpose.multiple.plot(plotList,plotTitle,...)
    return(obj)

  }
