% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anomalies.R
\name{anomalies}
\alias{anomalies}
\title{Analyze a dataset and search for anomalies}
\usage{
anomalies(data_analyze, anomaly_threshold = 0.8, distinct_threshold = 2)
}
\arguments{
\item{data_analyze}{a data frame or tibble to analyze}

\item{anomaly_threshold}{the minimum percentage of anomalous rows for the column to be problematic}

\item{distinct_threshold}{the minimum amount of distinct values the column has to have to not be problematic, usually you want to keep this at it's default value.}
}
\description{
If any anomalous columns are found, they are reported as a warning and returned in a data.frame. The anomalies we try to detect are high percentages of:
\itemize{
\item NA values
\item 0 values
\item Blank strings
\item Infinite numbers
}
And, also any columns with only one distinct value, which means the column doesn't bring information to the table (If all rows are equal, why bother having that column?)
}
\examples{

library(xray)
anomalies(mtcars, anomaly_threshold=0.5)

}
