% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xspline.R
\name{build_xspliner}
\alias{build_xspliner}
\title{Helper function for building GLM object with transformed variables.}
\usage{
build_xspliner(formula, model, data, xf_opts = xf_opts_default,
  xs_opts = xs_opts_default, link = "identity", family = "gaussian",
  env = parent.frame(), compare_stat = aic, control, ...)
}
\arguments{
\item{formula}{xspliner-specific formula object. Check vignette("xspliner") for more details.}

\item{model}{Predictive model. Basic model used for extracting predictors transformation.}

\item{data}{Training data of \code{model}.}

\item{xf_opts}{Formula parameters used for factor variable transformations inherited from factorMerger package.}

\item{xs_opts}{Predictive model response method and approximation parameters used for quantitative.}

\item{link}{Link function that should be used in final model. The passed is used when cannot be extracted from
model. By default 'identity'. See \link[stats]{family} for possibilities.}

\item{family}{Family of response variable that should be used in final model. The passed is used when cannot
be extracted from model. By default 'gaussian'. See \link[stats]{family} for possibilities.}

\item{env}{Environment in which optional variables passed into parameters are stored.}

\item{compare_stat}{Function of linear model (lm function output). Statistic that measures if linear model is better
that transformed one. See \link{stats}.}

\item{control}{Fitting settings. See \link{glm.control}.}

\item{...}{Another parameters passed from chosen method. Not used.}
}
\description{
Helper function for building GLM object with transformed variables.
}
