% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{xyz_search}
\alias{xyz_search}
\title{Interaction search}
\usage{
xyz_search(X, Y, L = 10, N = 100, binary = TRUE, negative = TRUE)
}
\arguments{
\item{X}{A matrix.}

\item{Y}{A vector.}

\item{L}{An integer indicating how many projection steps are performed.}

\item{N}{A integer, controlling the number of pairs that will be returned in the end.}

\item{binary}{A logical indicating if X is binary or continuous.}

\item{negative}{A logical indicating if also negative interactions should be searched for.}
}
\value{
\code{N} strongest interactions between \code{X} and \code{Y} after \code{L} projections.
}
\description{
Interaction search
}
\examples{
n<-300
p<-1000
#construct a binary matrix
X<-matrix(sample(c(-1,1),replace=TRUE,n*p),n,p)
#set an interaction of the pair (1,2)
Y<-X[,1]*X[,2]+rnorm(n)
#run the interaction search
result<-xyz_search(X,Y,L=10,N=10,binary=TRUE,negative=TRUE)
#print the result
print(result)
}
\references{
G. Thanei, N. Meinshausen and R. Shah (2016). The xyz algorithm for fast interaction search in high-dimensional data. <https://arxiv.org/pdf/1610.05108v1.pdf>
}
