% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index.R
\docType{class}
\name{Index-class}
\alias{Index-class}
\alias{Index}
\title{R6 Class Representing a Ticker}
\format{
An R6 class object
}
\description{
Base class for getting all data related to indices from Yahoo Finance API.
}
\examples{

## ------------------------------------------------
## Method `Index$new`
## ------------------------------------------------

nifty_50 <- Index$new('^NSEI')

## ------------------------------------------------
## Method `Index$set_index`
## ------------------------------------------------

indice <- Index$new('^NSEI')
indice$set_index('^NDX')

## ------------------------------------------------
## Method `Index$get_history`
## ------------------------------------------------

\donttest{
nifty <- Index$new('^NSEI')
nifty$get_history(start = '2022-07-01', interval = '1d')
nifty$get_history(start = '2022-07-01', end = '2022-07-14', interval = '1d')
nifty$get_history(period = '1mo', interval = '1d')
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{index}}{Index for which data is retrieved}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Index$new()}}
\item \href{#method-set_index}{\code{Index$set_index()}}
\item \href{#method-get_history}{\code{Index$get_history()}}
\item \href{#method-clone}{\code{Index$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new Index object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Index$new(index = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{Index}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `Index` object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{nifty_50 <- Index$new('^NSEI')
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_index"></a>}}
\if{latex}{\out{\hypertarget{method-set_index}{}}}
\subsection{Method \code{set_index()}}{
Set a new index.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Index$set_index(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{New index}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{indice <- Index$new('^NSEI')
indice$set_index('^NDX')
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_history"></a>}}
\if{latex}{\out{\hypertarget{method-get_history}{}}}
\subsection{Method \code{get_history()}}{
Retrieves historical data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Index$get_history(period = "ytd", interval = "1d", start = NULL, end = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{period}}{Length of time. Defaults to \code{'ytd'}. Valid values are:
\itemize{
\item \code{'1d'}
\item \code{'5d'}
\item \code{'1mo'}
\item \code{'3mo'}
\item \code{'6mo'}
\item \code{'1y'}
\item \code{'2y'}
\item \code{'5y'}
\item \code{'10y'}
\item \code{'ytd'}
\item \code{'max'}
}}

\item{\code{interval}}{Time between data points. Defaults to \code{'1d'}. Valid values are:
\itemize{
\item \code{'1m'}
\item \code{'2m'}
\item \code{'5m'}
\item \code{'15m'}
\item \code{'30m'}
\item \code{'60m'}
\item \code{'90m'}
\item \code{'1h'}
\item \code{'1d'}
\item \code{'5d'}
\item \code{'1wk'}
\item \code{'1mo'}
\item \code{'3mo'}
}}

\item{\code{start}}{Specific starting date. \code{String} or \code{date} object in \code{yyyy-mm-dd} format.}

\item{\code{end}}{Specific ending date. \code{String} or \code{date} object in \code{yyyy-mm-dd} format.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{data.frame}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
nifty <- Index$new('^NSEI')
nifty$get_history(start = '2022-07-01', interval = '1d')
nifty$get_history(start = '2022-07-01', end = '2022-07-14', interval = '1d')
nifty$get_history(period = '1mo', interval = '1d')
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Index$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
