% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{to_yamlet.numeric}
\alias{to_yamlet.numeric}
\title{Coerce Numeric to Yamlet Storage Format}
\usage{
\method{to_yamlet}{numeric}(x, ...)
}
\arguments{
\item{x}{object}

\item{...}{ignored}
}
\value{
length-one character
}
\description{
Coerces numeric to yamlet storage format.
By default, numeric values would be processed as character.
But character values with a leading dash are ordinarily 
quoted, since in character context a leading dash could
be mistaken for a yaml metacharacter.
In the case of a numeric value, however, we can be
fairly certain that, despite appearances, the dash
if any is actually a negative sign. This method
intends to leave negative numerics unquoted, like their
positive counterparts.
}
\examples{
library(magrittr)
 'a: [[d: [-1, 0, 1, 2]]]' \%>\% as_yamlet \%>\% to_yamlet
 to_yamlet(c(a = 4, b = 5.8))
 to_yamlet(list(a = 4, b = 5.8))
 to_yamlet(numeric(0))
}
\seealso{
Other to_yamlet: 
\code{\link{to_yamlet}()},
\code{\link{to_yamlet.NULL}()},
\code{\link{to_yamlet.character}()},
\code{\link{to_yamlet.default}()},
\code{\link{to_yamlet.list}()},
\code{\link{to_yamlet.yamlet}()}
}
\concept{to_yamlet}
\keyword{internal}
