% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob-lift_curve.R
\name{lift_curve}
\alias{lift_curve}
\alias{lift_curve.data.frame}
\title{Lift curve}
\usage{
lift_curve(data, ...)

\method{lift_curve}{data.frame}(
  data,
  truth,
  ...,
  na_rm = TRUE,
  event_level = yardstick_event_level(),
  case_weights = NULL
)
}
\arguments{
\item{data}{A \code{data.frame} containing the columns specified by \code{truth} and
\code{...}.}

\item{...}{A set of unquoted column names or one or more
\code{dplyr} selector functions to choose which variables contain the
class probabilities. If \code{truth} is binary, only 1 column should be selected,
and it should correspond to the value of \code{event_level}. Otherwise, there
should be as many columns as factor levels of \code{truth} and the ordering of
the columns should be the same as the factor levels of \code{truth}.}

\item{truth}{The column identifier for the true class results
(that is a \code{factor}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column
names). For \verb{_vec()} functions, a \code{factor} vector.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}

\item{event_level}{A single string. Either \code{"first"} or \code{"second"} to specify
which level of \code{truth} to consider as the "event". This argument is only
applicable when \code{estimator = "binary"}. The default uses an
internal helper that generally defaults to \code{"first"}, however, if the
deprecated global option \code{yardstick.event_first} is set, that will be
used instead with a warning.}

\item{case_weights}{The optional column identifier for case weights.
This should be an unquoted column name that evaluates to a numeric column
in \code{data}. For \verb{_vec()} functions, a numeric vector.}
}
\value{
A tibble with class \code{lift_df} or \code{lift_grouped_df} having
columns:
\itemize{
\item \code{.n} The index of the current sample.
\item \code{.n_events} The index of the current \emph{unique} sample. Values with repeated
\code{estimate} values are given identical indices in this column.
\item \code{.percent_tested} The cumulative percentage of values tested.
\item \code{.lift} First calculate the cumulative percentage of true results relative
to the total number of true results. Then divide that by \code{.percent_tested}.
}

If using the \code{case_weights} argument, all of the above columns will be
weighted. This makes the most sense with frequency weights, which are integer
weights representing the number of times a particular observation should be
repeated.
}
\description{
\code{lift_curve()} constructs the full lift curve and returns a tibble. See
\code{\link[=gain_curve]{gain_curve()}} for a closely related concept.
}
\details{
There is a \code{\link[ggplot2:autoplot]{ggplot2::autoplot()}} method for quickly visualizing the curve.
This works for binary and multiclass output, and also works with grouped data
(i.e. from resamples). See the examples.
}
\section{Gain and Lift Curves}{


The motivation behind cumulative gain and lift charts is as a visual method
to determine the effectiveness of a model when compared to the results one
might expect without a model. As an example, without a model, if you were to
advertise to a random 10\% of your customer base, then you might expect to
capture 10\% of the of the total number of positive responses had you
advertised to your entire customer base. Given a model that predicts which
customers are more likely to respond, the hope is that you can more
accurately target 10\% of your customer base and capture \code{>}10\% of the total
number of positive responses.

The calculation to construct lift curves is as follows:
\enumerate{
\item \code{truth} and \code{estimate} are placed in descending order by the \code{estimate}
values (\code{estimate} here is a single column supplied in \code{...}).
\item The cumulative number of samples with true results relative to the
entire number of true results are found.
\item The cumulative \verb{\%} found is divided by the cumulative \verb{\%} tested
to construct the lift value. This ratio represents the factor of improvement
over an uninformed model. Values \code{>}1 represent a valuable model. This is the
y-axis of the lift chart.
}
}

\section{Multiclass}{


If a multiclass \code{truth} column is provided, a one-vs-all
approach will be taken to calculate multiple curves, one per level.
In this case, there will be an additional column, \code{.level},
identifying the "one" column in the one-vs-all calculation.
}

\section{Relevant Level}{


There is no common convention on which factor level should
automatically be considered the "event" or "positive" result
when computing binary classification metrics. In \code{yardstick}, the default
is to use the \emph{first} level. To alter this, change the argument
\code{event_level} to \code{"second"} to consider the \emph{last} level of the factor the
level of interest. For multiclass extensions involving one-vs-all
comparisons (such as macro averaging), this option is ignored and
the "one" level is always the relevant result.
}

\examples{
# ---------------------------------------------------------------------------
# Two class example

# `truth` is a 2 level factor. The first level is `"Class1"`, which is the
# "event of interest" by default in yardstick. See the Relevant Level
# section above.
data(two_class_example)

# Binary metrics using class probabilities take a factor `truth` column,
# and a single class probability column containing the probabilities of
# the event of interest. Here, since `"Class1"` is the first level of
# `"truth"`, it is the event of interest and we pass in probabilities for it.
lift_curve(two_class_example, truth, Class1)

# ---------------------------------------------------------------------------
# `autoplot()`

library(ggplot2)
library(dplyr)

# Use autoplot to visualize
autoplot(lift_curve(two_class_example, truth, Class1))

# Multiclass one-vs-all approach
# One curve per level
hpc_cv \%>\%
  filter(Resample == "Fold01") \%>\%
  lift_curve(obs, VF:L) \%>\%
  autoplot()

# Same as above, but will all of the resamples
hpc_cv \%>\%
  group_by(Resample) \%>\%
  lift_curve(obs, VF:L) \%>\%
  autoplot()

}
\seealso{
Other curve metrics: 
\code{\link{gain_curve}()},
\code{\link{pr_curve}()},
\code{\link{roc_curve}()}
}
\author{
Max Kuhn
}
\concept{curve metrics}
