% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nav.R
\name{navInput}
\alias{navInput}
\alias{updateNavInput}
\title{Page navigation inputs}
\usage{
navInput(id, choices = NULL, values = choices,
  selected = values[[1]], ..., appearance = "links", fill = FALSE)

updateNavInput(id, choices = NULL, values = choices, selected = NULL,
  enable = NULL, disable = NULL,
  session = getDefaultReactiveDomain())
}
\arguments{
\item{id}{A character string specifying the id of the reactive input.}

\item{choices}{A character vector or list of tag elements specifying the
navigation items of the input.}

\item{values}{A character vector specifying the values of the input's
chocies, defaults to \code{choices}.}

\item{selected}{One of \code{values} specifying which choice is selected by
default, defaults to \code{values[[1]]}.}

\item{...}{Additional named arguments passed as HTML attributes to the
parent element or tag elements passed as child elements to the parent
element.}

\item{appearance}{One of \code{"links"}, \code{"pills"}, or \code{"tabs"} specifying the
appearance of the nav input, defaults to \code{"links"}.}

\item{fill}{One of \code{TRUE} or \code{FALSE} specifying if the nav input fills the
width of its parent element. If \code{TRUE}, the space is divided evenly among
the nav items.}

\item{enable}{One of \code{values} specifying particular choices to enable or
\code{TRUE} specifying the entire input is enabled, defaults to \code{NULL}.}

\item{disable}{One of \code{values} specifying particular choices to disable or
\code{TRUE} specifying the entire input is disabled, defaults to \code{NULL}.}

\item{session}{A reactive context, defaults to \code{\link[=getDefaultReactiveDomain]{getDefaultReactiveDomain()}}.}
}
\description{
A reactive input styled as a navigation control. The navigation input can be
styled as links, tabs, or pills. A nav input is paired with \code{\link[=navContent]{navContent()}}
and \code{\link[=showNavPane]{showNavPane()}} to create tabbed user interfaces. Observers and reactives
are triggered when a nav choice or menu item is clicked. The reactive value
of a nav input is \code{NULL} or a singleton character string. The value of any
menus in the nav input must be retrieved with its own reactive id.
}
\section{Including a menu}{


Use the reactive id of any nav menus to know when a menu item is clicked.\preformatted{ui <- navInput(
  id = "navigation",
  choices = list(
    "Item 1",
    "Item 2",
    menuInput(
      id = "navMenu",  # <-
      label = "Item 3",
      choices = c("Choice 1", "Choice 2")
    )
  ),
  values = c("item1", "item2", "item3")
)

server <- function(input, output) {
  observeEvent(input$navMenu, {
    cat(paste("Click menu item:", input$navMenu, "\n"))
  })
}

shinyApp(ui, server)
}
}

\examples{

### Nav styled as tabs

navInput(
  id = "tabs1",
  choices = c(
    "Tab 1",
    "Tab 2",
    "Tab 3"
  ),
  selected = "Tab 1",
  appearance = "tabs"
)

### Nav styled as pills

navInput(
  id = "tabs2",
  choices = paste("Tab", 1:3),
  selected = "Tab 1",
  appearance = "pills"
)

### Nav with dropdown

navInput(
  id = "tabs3",
  choices = list(
    "Tab 1",
    menuInput(
      id = "menu1",
      label = "Tab 2",
      choices = c(
        "Action",
        "Another action"
      )
    ),
    "Tab 2"
  ),
  values = c("tab1", "tab2", "tab3")
)

### Full width nav input

navInput(
  id = "tabs4",
  choices = paste("Tab", 1:5),
  values = paste0("tab", 1:5),
  appearance = "pills",
  fill = TRUE
)

### Centering a nav input

navInput(
  id = "tabs5",
  choices = paste("Tab", 1:3)
) \%>\%
  flex(justify = "center")

}
\seealso{
Other inputs: \code{\link{buttonGroupInput}},
  \code{\link{buttonInput}}, \code{\link{checkbarInput}},
  \code{\link{checkboxInput}}, \code{\link{chipInput}},
  \code{\link{fileInput}}, \code{\link{formInput}},
  \code{\link{listGroupInput}}, \code{\link{menuInput}},
  \code{\link{radioInput}}, \code{\link{radiobarInput}},
  \code{\link{rangeInput}}, \code{\link{selectInput}},
  \code{\link{textInput}}
}
\concept{inputs}
