% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/destructure.R
\name{destructure-methods}
\alias{destructure-methods}
\alias{destructure.character}
\alias{destructure.complex}
\alias{destructure.Date}
\alias{destructure.data.frame}
\alias{destructure.summary.lm}
\alias{destructure.default}
\title{Included Implementations of \code{destructure}}
\usage{
\method{destructure}{character}(x)

\method{destructure}{complex}(x)

\method{destructure}{Date}(x)

\method{destructure}{data.frame}(x)

\method{destructure}{summary.lm}(x)

\method{destructure}{default}(x)
}
\arguments{
\item{x}{An \R object.}
}
\value{
A list of elements from \code{x}.
}
\description{
zeallot includes \code{destructure} methods for the following classes:
\code{character}, \code{complex}, \code{Date}, \code{data.frame}, and
\code{summary.lm}. See details for how each object is transformed into a
list.
}
\details{
\code{character} values are split into a list of individual characters.

\code{complex} values are split into a list of two values, the real and the
imaginary part.

\code{Date} values are split into a list of three numeric values, the year,
month, and day.

\code{data.frame} values are coerced into a list using \code{as.list}.

\code{summary.lm} values are coerced into a list of values, one element for
each of the eleven values returned by \code{summary.lm}.
}
\seealso{
\code{\link{destructure}}
}
\keyword{internal}
