% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZenodoRecord.R
\docType{class}
\name{ZenodoRecord}
\alias{ZenodoRecord}
\title{ZenodoRecord}
\format{\code{\link{R6Class}} object.}
\usage{
ZenodoRecord
}
\value{
Object of \code{\link{R6Class}} for modelling an ZenodoRecord
}
\description{
ZenodoRecord
}
\section{Methods}{

\describe{
 \item{\code{new()}}{
   This method is used to instantiate a Zenodo Record
 }
 \item{\code{prereserveDOI(prereserve)}}{
   Set prereserve_doi if \code{TRUE}, \code{FALSE} otherwise to create a record without
   prereserved DOI by Zenodo. By default, this method will be called to prereserve a DOI
   assuming the record created doesn't yet handle a DOI. To avoid prereserving a DOI 
   call \code{$prereserveDOI(FALSE)} on your record.
 }
 \item{\code{setUploadType(uploadType)}}{
   Set the upload type (mandatory). Value should be among the following: 'publication',
   'poster','presentation','dataset','image','video', or 'software'
 }
 \item{\code{setPublicationType(publicationType)}}{
   Set the publication type (mandatory if upload type is 'publication'). Value should be
   among the following: 'book','section','conferencepaper','article','patent','preprint',
   'report','softwaredocumentation','thesis','technicalnote','workingpaper', or 'other'
 }
 \item{\code{setImageType(imageType)}}{
   Set the image type (mandatory if image type is 'image'). Value should be among the 
   following: 'figure','plot','drawing','diagram','photo', or 'other'
 }
 \item{\code{setPublicationDate(publicationDate)}}{
   Set the publication date, as object of class \code{Date}
 }
 \item{\code{setEmbargoDate(embargoDate)}}{
   Set the embargo date, as object of class \code{Date}
 }
 \item{\code{setTitle(title)}}{
   Set title
 }
 \item{\code{setDescription(description)}}{
   Set description
 }
 \item{\code{setAccessRight(accessRight)}}{
   Set the access right. Value should be among the following: 'open','embargoed',
   'restricted','closed'
 }
 \item{\code{setAccessConditions(accessConditions)}}{
   Set access conditions.
 }
 \item{\code{addCreator(firsname, lastname, affiliation, orcid, gnd)}}{
   Add a creator for the record.
 }
 \item{\code{removeCreator(by,property)}}{
   Removes a creator by a property. The \code{by} parameter should be the name
   of the creator property ('name' - in the form 'lastname, firstname', 'affiliation',
   'orcid' or 'gnd'). Returns \code{TRUE} if some creator was removed, 
   \code{FALSE} otherwise.
 }
 \item{\code{removeCreatorByName(name)}}{
   Removes a creator by name. Returns \code{TRUE} if some creator was removed, 
   \code{FALSE} otherwise.
 }
 \item{\code{removeCreatorByAffiliation(affiliation)}}{
   Removes a creator by affiliation. Returns \code{TRUE} if some creator was removed, 
   \code{FALSE} otherwise.
 }
 \item{\code{removeCreatorByORCID(orcid)}}{
   Removes a creator by ORCID. Returns \code{TRUE} if some creator was removed, 
   \code{FALSE} otherwise.
 }
 \item{\code{setLicense(licenseId)}}{
   Set license. The license should be set with the Zenodo id of the license. If not
   recognized by Zenodo, the function will return an error. The list of licenses can
   fetched with the \code{ZenodoManager} and the function \code{$getLicenses()}.
 }
 \item{\code{setDOI(doi)}}{
   Set the DOI. This method can be used if a DOI has been already assigned outside Zenodo.
   This method will call the method \code{$prereserveDOI(FALSE)}.
 }
 \item{\code{setVersion(version)}}{
   Set the version.
 }
 \item{\code{setLanguage(language)}}{
   Set the language ISO 639-2 or 639-3 code.
 }
 \item{\code{addRelatedIdentifier(relation, identifier)}}{
   Adds a related identifier with a given relation. Relation can be one of among
   following values: isCitedBy, cites, isSupplementTo, isSupplementedBy, isNewVersionOf,
   isPreviousVersionOf, isPartOf, hasPart, compiles, isCompiledBy, isIdenticalTo, 
   isAlternateIdentifier
 }
 \item{code{removeRelatedIdentifier(relation, identifier)}}{
   Remove a related identifier
 }
 \item{\code{setKeywords(keywords)}}{
   Set a vector of character strings as keywords
 }
 \item{\code{addKeyword(keyword)}}{
   Adds a keyword to the record metadata. Return \code{TRUE} if added, 
   \code{FALSE} otherwise.
 }
 \item{\code{removedKeyword(keyword)}}{
   Removes a keyword from the record metadata. Return \code{TRUE} if removed, 
   \code{FALSE} otherwise.
 }
 \item{\code{addSubject(term, identifier)}}{
   Add a Subject for the record.
 }
 \item{\code{removeSubject(by,property)}}{
   Removes a subject by a property. The \code{by} parameter should be the name
   of the subject property ('term' or 'identifier'). Returns \code{TRUE} if some 
   subject was removed, \code{FALSE} otherwise.
 }
 \item{\code{removeSubjectByTerm(term)}}{
   Removes a subject by term. Returns \code{TRUE} if some subject was removed, 
   \code{FALSE} otherwise.
 }
 \item{\code{removeSubjectByIdentifier(identifier)}}{
   Removes a subject by identifier. Returns \code{TRUE} if some subject was removed, 
   \code{FALSE} otherwise.
 }
 \item{\code{setNotes(notes)}}{
   Set notes. HTML is not allowed
 }
 \item{\code{setCommunities(communities)}}{
   Set a vector of character strings identifying communities
 }
 \item{\code{addCommunity(community)}}{
   Adds a community to the record metadata. Return \code{TRUE} if added, 
   \code{FALSE} otherwise. The community should be set with the Zenodo id of the community. If not
   recognized by Zenodo, the function will return an error. The list of communities can
   fetched with the \code{ZenodoManager} and the function \code{$getCommunities()}.
 }
 \item{\code{removedCommunity(community)}}{
   Removes a community from the record metadata. Return \code{TRUE} if removed, 
   \code{FALSE} otherwise.
 }
}
}

\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{record}
\keyword{zenodo}
