% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zetadiv.R
\name{Zeta.ddecays}
\alias{Zeta.ddecays}
\title{Zeta distance decay for a range of numbers of assemblages or sites}
\usage{
Zeta.ddecays(
  xy,
  data.spec,
  orders = 2:10,
  sam = 1000,
  family = stats::gaussian(),
  distance.type = "Euclidean",
  dist.custom = NULL,
  method = "mean",
  confint.level = 0.95,
  trsf = "NULL",
  cutoff = NULL,
  rescale = FALSE,
  normalize = FALSE,
  plot = TRUE
)
}
\arguments{
\item{xy}{Site-by-coordinate data frame, with sites as rows and coordinates as columns.}

\item{data.spec}{Site-by-species presence-absence data frame, with sites as rows and species as columns.}

\item{orders}{Range of number of assemblages or sites at which zeta diversity is computed. All the orders must be striclty greater than 1.}

\item{sam}{Number of samples for which the zeta diversity is computed.}

\item{family}{A description of the error distribution and link function to be used in the generalised linear models (see \code{\link[stats]{family}} for details of family functions).}

\item{distance.type}{Method to compute distance. Default is "\code{Euclidean}", for Euclidean distance. The other options are (i) "\code{ortho}" for orthodromic distance, if xy correspond to longitudes and latitudes (orthodromic distance is computed using the \code{gdist} function from package \code{Imap}); and (ii) "\code{custom}", in which case the user must provide a distance matrix for \code{dist.custom}.}

\item{dist.custom}{Distance matrix provided by the user when \code{distance.type} = \code{"custom"}.}

\item{method}{Name of a function (as a string) indicating how to combine the pairwise differences and distances for more than 3 sites. It can be a basic R-function such as "\code{mean}" or "\code{max}", but also a custom function.}

\item{confint.level}{Percentage for the confidence intervals of the coefficients from the linear regression.}

\item{trsf}{Name of a function (as a string) indicating how to transform distance. Default is "NULL" for the identity transformation.}

\item{cutoff}{If specified, maximum distance value for which the linear regression must be performed.}

\item{rescale}{Boolean value (TRUE or FALSE) indicating if the zeta values should be divided by \eqn{\zeta_1}, to get a range of values between 0 and 1. Has no effect if \code{normalize} != \code{FALSE}.}

\item{normalize}{Indicates if the zeta values for each sample should be divided by the total number of species for this specific sample (\code{normalize = "Jaccard"}), by the average number of species per site for this specific sample (\code{normalize = "Sorensen"}), or by the minimum number of species in the sites of this specific sample \cr (\code{normalize = "Simpson"}). Default value is \code{FALSE}, indicating that no normalization is performed.}

\item{plot}{Boolean value (TRUE or FALSE) indicating if the outputs must be plotted.}
}
\value{
\code{Zeta.ddecays} returns a list containing the following components:

\item{orders}{Range of number of assemblages or sites at which zeta diversity was computed.}

\item{coefs}{A vector of the coefficients from the generalised linear models for the numbers of sites specified by \code{orders}.}

\item{confint}{The confidence intervals for the coefficients from the generalised linear models.}
}
\description{
Computes the distance decay of zeta diversity for a range of orders (number of assemblages or sites), using generalised linear models.
}
\examples{
utils::data(bird.spec.coarse)
xy.bird <- bird.spec.coarse[,1:2]
data.spec.bird <- bird.spec.coarse[,3:193]

dev.new()
zeta.ddecays.bird <- Zeta.ddecays(xy.bird, data.spec.bird, sam = 100, orders = 2:5,
    plot = TRUE, confint.level = 0.95)

##########

utils::data(Marion.species)
xy.marion <- Marion.species[,1:2]
data.spec.marion <- Marion.species[,3:33]

dev.new()
zeta.ddecays.marion <- Zeta.ddecays(xy.marion, data.spec.marion, sam = 100,
   orders = 2:5, plot = TRUE, confint.level = 0.95)

}
\references{
Hui C. & McGeoch M.A. (2014). Zeta diversity as a concept and metric that unifies incidence-based biodiversity patterns. \emph{The American Naturalist}, 184, 684-694.
}
\seealso{
\code{\link{Zeta.decline.mc}}, \code{\link{Zeta.order.mc}}, \code{\link{Zeta.decline.ex}}, \code{\link{Zeta.order.ex}}, \code{\link{Zeta.ddecay}}
}
