% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmmviterbi.cont.R
\name{hmmviterbi.cont}
\alias{hmmviterbi.cont}
\title{Viterbi algorithm to decode the latent states for continuous-time
hidden Markov models}
\usage{
hmmviterbi.cont(y, M, prior_init, tpm_init, emit_init, zero_init, timeindex,
  plot = FALSE, xlim = NULL, ylim = NULL, ...)
}
\arguments{
\item{y}{the observed series to be decoded}

\item{M}{number of latent states}

\item{prior_init}{a vector of prior probability values}

\item{tpm_init}{transition rate matrix}

\item{emit_init}{a vector containing means for each poisson distribution}

\item{zero_init}{a vector containing structural zero proportions in each state}

\item{timeindex}{a vector containing the time points}

\item{plot}{whether a plot should be returned}

\item{xlim}{vector specifying the minimum and maximum on the x-axis in the plot. 
Default to NULL.}

\item{ylim}{vector specifying the minimum and maximum on the y-axis in the plot. 
Default to NULL.}

\item{...}{further arguments to be passed to the plot() function}
}
\value{
the decoded series of latent states
}
\description{
Viterbi algorithm to decode the latent states for continuous-time
hidden Markov models
}
\examples{
prior_init <- c(0.5,0.2,0.3)
emit_init <- c(10,40,70)
zero_init <- c(0.5,0,0)
omega <- matrix(c(-0.3,0.2,0.1,0.1,-0.2,0.1,0.2,0.2,-0.4),3,3,byrow=TRUE)
timeindex <- rep(1,1000)
for(i in 2:1000) timeindex[i] <- timeindex[i-1] + sample(1:3,1)
result <- hmmsim.cont(n=1000,M=3,prior=prior_init, tpm_parm=omega,
          emit_parm=emit_init,zeroprop=zero_init,timeindex=timeindex)
y <- result$series
fit2 <-  fasthmmfit.cont(y,x=NULL,M=3,prior_init,omega,
                        emit_init,0.5,timeindex=timeindex,hessian=FALSE,
                        method="BFGS", control=list(maxit=500,trace=1))
decode2 <- hmmviterbi.cont(y,3,fit2$prior,fit2$tpm,fit2$emit,
           c(fit2$zeroprop,0,0),timeindex=timeindex)    

}
\references{
Walter Zucchini, Iain L. MacDonald, Roland Langrock. Hidden Markov Models for 
Time Series: An Introduction Using R, Second Edition. Chapman & Hall/CRC
}
