% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zi_get_demographics.R
\name{zi_get_demographics}
\alias{zi_get_demographics}
\title{Download Demographic Data for Five-digit ZCTAs}
\usage{
zi_get_demographics(year, variables = NULL, table = NULL,
    survey, output = "tidy", zcta = NULL, key = NULL)
}
\arguments{
\item{year}{A four-digit numeric scalar for year. \code{zippeR} currently
supports data for from 2010 to 2022. Different \code{survey} products
are available for different years. See the \code{survey} parameter
for more details}

\item{variables}{A character scalar or vector of variable IDs.}

\item{table}{A character scalar of a table ID (only one table may be
requested per call).}

\item{survey}{A character scalar representing the Census product. It can
be either a Decennial Census product (either \code{"sf1"} or \code{"sf3"})
or an American Community Survey product (either \code{"acs1"},
\code{"acs3"}, or \code{"acs5"}). For Decennial Census calls, only the 2010
Census is available. In addition, if a variable cannot be found in \code{"sf1"},
the function will look in \code{"sf3"}. Also note that \code{"acs3"} was
discontinued after 2013.}

\item{output}{A character scalar; one of \code{"tidy"} (long output) or
\code{"wide"} depending on the type of data format you want. If you are
planning to pass these data to \code{zi_aggregate()}, you must choose
\code{"tidy"}. If you are leaving these data as five-digit ZCTAs and are
planning to join them with geometric data, \code{"wide"} is the
strongly encouraged format.}

\item{zcta}{An optional vector of ZCTAs that demographic data are requested
for. If this is \code{NULL}, data will be returned for all ZCTAs. If a
vector is supplied, only data for those requested ZCTAs will be returned.
The vector can be created with \code{zi_get_geometry()} and should only
contain five-digit ZCTAs.}

\item{key}{A Census API key, which can be obtained at
\url{https://api.census.gov/data/key_signup.html}. This can be omitted if
\code{tidycensus::census_api_key()} has been used to write your key to
your \code{.Renviron} file. You can check whether an API key has been
written to \code{.Renviron} by using \code{Sys.getenv("CENSUS_API_KEY")}.}
}
\value{
A tibble containing all demographic data requested in either
    \code{"tidy"} or \code{"wide"} format.
}
\description{
This function returns demographic data for five-digit ZIP Code
    Tabulation Areas (ZCTAs), which are rough approximations of many (but not
    all) USPS ZIP codes.
}
\examples{
\donttest{
  # download all ZCTAs
  zi_get_demographics(year = 2012, variables = "B01003_001", survey = "acs5")

  # limit output to subset of ZCTAs
  ## download all ZCTAs in Missouri, intersects method
  mo20 <- zi_get_geometry(year = 2020, state = "MO", method = "intersect")

  ## download demographic data
  zi_get_demographics(year = 2012, variables = "B01003_001", survey = "acs5",
      zcta = mo20$GEOID)
}

}
