% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_missing_limits.R
\name{set_missing_limits}
\alias{set_missing_limits}
\title{Set Missing Limits in Reference Tables}
\usage{
set_missing_limits(x, fraction = c(0.15, 20/3))
}
\arguments{
\item{x}{\code{data.frame}, reference table, has to have the columns:
"lower" and "upper", \code{numeric} for the lower and upper reference
limits.  Additional columns are allowed (and ignored).}

\item{fraction}{\code{numeric(2)}, targeted fraction of the lower to the upper and
the upper to the lower limit. Haeckel et al. 2015 suggested to set the lower
limit to 0.15 of the upper one. We choose 20/3 (the reciprocal of 0.15) for
the upper to the lower one.}
}
\value{
\code{data.frame}, the same as \code{x} but the "lower" and "upper" columns are
modified if there were \code{NA} before.
}
\description{
Sometimes reference limits are not specified. That is often the case for
biomarkers that are related to infection or cancer. Using zero as lower
boundary results in skewed distributions (Hoffmann et al. 2017; fig. 7).
Haeckel et al. 2015 suggested to set the lower reference limit to 0.15 of
the upper one.
}
\examples{
reference <- data.frame(
    param = c("albumin", rep("bilirubin", 4)),
    age = c(0, 1, 2, 3, 7),             # ignored
    sex = "both",                       # ignored
    units = c("g/l", rep("µmol/l", 4)), # ignored
    lower = c(35, rep(NA, 4)),  # no real reference values
    upper = c(52, 5, 8, 13, 18) # no real reference values
)
set_missing_limits(reference)
set_missing_limits(reference, fraction = c(0.2, 5))
}
\references{
Georg Hoffmann, Frank Klawonn, Ralf Lichtinghagen, and Matthias Orth.
2017.
"The Zlog-Value as Basis for the Standardization of Laboratory Results."
LaboratoriumsMedizin 41 (1): 23–32.
\doi{10.1515/labmed-2016-0087}.

Rainer Haeckel, Werner Wosniok, Ebrhard Gurr and Burkhard Peil.
2015.
"Permissible limits for uncertainty of measurement in laboratory medicine"
Clinical Chemistry and Laboratory Medicine 53 (8): 1161-1171.
\doi{10.1515/cclm-2014-0874}.
}
\author{
Sebastian Gibb
}
