% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{create_zproject}
\alias{create_zproject}
\title{Create a new Zonation project on file system.}
\usage{
create_zproject(name, dir, variants, dat_template_file = NULL,
  spp_template_file = NULL, spp_template_dir = NULL, overwrite = FALSE,
  debug = FALSE, ...)
}
\arguments{
\item{name}{Character string name for the project. A new directory named
by \code{name} will be creaated in a location specified by \code{dir}.}

\item{dir}{Character string path pointing to a location to be created.}

\item{variants}{Character vector of names for new variants. Ignored if using
an existing project.}

\item{dat_template_file}{Character path to a dat file template. If no
template is specified, uses the template distributed with zonator. Ignored
if using an existing project.}

\item{spp_template_file}{Character path to a spp file template. If this or
\code{spp_template_dir} are not specified, uses the template
distributed with zonator. Ignored if using an existing project.}

\item{spp_template_dir}{Character path to directory containing biodiversity
feature rasters. If this or \code{spp_template_file} are not specified,
uses the template distributed with zonator. If both are defined, then
\code{spp_template_dir} overrides. Ignored if using an existing
project.}

\item{overwrite}{logical should existing project be overwritten (default:
FALSE).}

\item{debug}{logical defining if debugging level for logging should be used
(default: FALSE).}

\item{...}{additional arguments passed to \code{\link{create_spp}}.}
}
\value{
Invisible(NULL) .
}
\description{
Based on a set of input arguments, creates a new Zonation project on the
file system following a particular folder and file layout.
}
\note{
This function is used only for the intended side-effect of creating a
  new Zonation project. To load the project as an instance of
  \code{\link[zonator:Zproject-class]{Zproject-class}}, see
  \code{\link[zonator:load_zproject]{load_zproject}}.
}
\seealso{
\code{\link[zonator:load_zproject]{load_zproject}} and
  \code{\link[zonator:create_spp]{create_spp}}.
}
\author{
Joona Lehtomaki \email{joona.lehtomaki@gmail.com}
}
