






#![allow(dead_code)]
use core::{
    mem::MaybeUninit,
    ptr,
    sync::atomic::{AtomicUsize, Ordering::Relaxed},
};



















pub struct LazyUsize(AtomicUsize);

impl LazyUsize {
    pub const fn new() -> Self {
        Self(AtomicUsize::new(Self::UNINIT))
    }


    pub const UNINIT: usize = usize::max_value();




    pub fn unsync_init(&self, init: impl FnOnce() -> usize) -> usize {

        let mut val = self.0.load(Relaxed);
        if val == Self::UNINIT {
            val = init();
            self.0.store(val, Relaxed);
        }
        val
    }
}


pub struct LazyBool(LazyUsize);

impl LazyBool {
    pub const fn new() -> Self {
        Self(LazyUsize::new())
    }

    pub fn unsync_init(&self, init: impl FnOnce() -> bool) -> bool {
        self.0.unsync_init(|| init() as usize) != 0
    }
}




#[inline(always)]
pub unsafe fn slice_assume_init_mut<T>(slice: &mut [MaybeUninit<T>]) -> &mut [T] {

    &mut *(slice as *mut [MaybeUninit<T>] as *mut [T])
}

#[inline]
pub fn uninit_slice_fill_zero(slice: &mut [MaybeUninit<u8>]) -> &mut [u8] {
    unsafe { ptr::write_bytes(slice.as_mut_ptr(), 0, slice.len()) };
    unsafe { slice_assume_init_mut(slice) }
}

#[inline(always)]
pub fn slice_as_uninit<T>(slice: &[T]) -> &[MaybeUninit<T>] {



    unsafe { &*(slice as *const [T] as *const [MaybeUninit<T>]) }
}





#[inline(always)]
pub unsafe fn slice_as_uninit_mut<T>(slice: &mut [T]) -> &mut [MaybeUninit<T>] {

    &mut *(slice as *mut [T] as *mut [MaybeUninit<T>])
}
