use super::noop::NoopConsumer;
use super::{FromParallelIterator, IntoParallelIterator, ParallelExtend, ParallelIterator};

use std::borrow::Cow;
use std::collections::LinkedList;
use std::collections::{BTreeMap, BTreeSet, HashMap, HashSet};
use std::collections::{BinaryHeap, VecDeque};
use std::hash::{BuildHasher, Hash};
use std::rc::Rc;
use std::sync::Arc;


fn collect_extended<C, I>(par_iter: I) -> C
where
    I: IntoParallelIterator,
    C: ParallelExtend<I::Item> + Default,
{
    let mut collection = C::default();
    collection.par_extend(par_iter);
    collection
}


impl<T> FromParallelIterator<T> for Vec<T>
where
    T: Send,
{
    fn from_par_iter<I>(par_iter: I) -> Self
    where
        I: IntoParallelIterator<Item = T>,
    {
        collect_extended(par_iter)
    }
}


impl<T> FromParallelIterator<T> for Box<[T]>
where
    T: Send,
{
    fn from_par_iter<I>(par_iter: I) -> Self
    where
        I: IntoParallelIterator<Item = T>,
    {
        Vec::from_par_iter(par_iter).into()
    }
}


impl<T> FromParallelIterator<T> for Rc<[T]>
where
    T: Send,
{
    fn from_par_iter<I>(par_iter: I) -> Self
    where
        I: IntoParallelIterator<Item = T>,
    {
        Vec::from_par_iter(par_iter).into()
    }
}


impl<T> FromParallelIterator<T> for Arc<[T]>
where
    T: Send,
{
    fn from_par_iter<I>(par_iter: I) -> Self
    where
        I: IntoParallelIterator<Item = T>,
    {
        Vec::from_par_iter(par_iter).into()
    }
}


impl<T> FromParallelIterator<T> for VecDeque<T>
where
    T: Send,
{
    fn from_par_iter<I>(par_iter: I) -> Self
    where
        I: IntoParallelIterator<Item = T>,
    {
        Vec::from_par_iter(par_iter).into()
    }
}



impl<T> FromParallelIterator<T> for BinaryHeap<T>
where
    T: Ord + Send,
{
    fn from_par_iter<I>(par_iter: I) -> Self
    where
        I: IntoParallelIterator<Item = T>,
    {
        Vec::from_par_iter(par_iter).into()
    }
}



impl<T> FromParallelIterator<T> for LinkedList<T>
where
    T: Send,
{
    fn from_par_iter<I>(par_iter: I) -> Self
    where
        I: IntoParallelIterator<Item = T>,
    {
        collect_extended(par_iter)
    }
}





impl<K, V, S> FromParallelIterator<(K, V)> for HashMap<K, V, S>
where
    K: Eq + Hash + Send,
    V: Send,
    S: BuildHasher + Default + Send,
{
    fn from_par_iter<I>(par_iter: I) -> Self
    where
        I: IntoParallelIterator<Item = (K, V)>,
    {
        collect_extended(par_iter)
    }
}





impl<K, V> FromParallelIterator<(K, V)> for BTreeMap<K, V>
where
    K: Ord + Send,
    V: Send,
{
    fn from_par_iter<I>(par_iter: I) -> Self
    where
        I: IntoParallelIterator<Item = (K, V)>,
    {
        collect_extended(par_iter)
    }
}


impl<V, S> FromParallelIterator<V> for HashSet<V, S>
where
    V: Eq + Hash + Send,
    S: BuildHasher + Default + Send,
{
    fn from_par_iter<I>(par_iter: I) -> Self
    where
        I: IntoParallelIterator<Item = V>,
    {
        collect_extended(par_iter)
    }
}


impl<V> FromParallelIterator<V> for BTreeSet<V>
where
    V: Send + Ord,
{
    fn from_par_iter<I>(par_iter: I) -> Self
    where
        I: IntoParallelIterator<Item = V>,
    {
        collect_extended(par_iter)
    }
}


impl FromParallelIterator<char> for String {
    fn from_par_iter<I>(par_iter: I) -> Self
    where
        I: IntoParallelIterator<Item = char>,
    {
        collect_extended(par_iter)
    }
}


impl<'a> FromParallelIterator<&'a char> for String {
    fn from_par_iter<I>(par_iter: I) -> Self
    where
        I: IntoParallelIterator<Item = &'a char>,
    {
        collect_extended(par_iter)
    }
}


impl<'a> FromParallelIterator<&'a str> for String {
    fn from_par_iter<I>(par_iter: I) -> Self
    where
        I: IntoParallelIterator<Item = &'a str>,
    {
        collect_extended(par_iter)
    }
}


impl FromParallelIterator<String> for String {
    fn from_par_iter<I>(par_iter: I) -> Self
    where
        I: IntoParallelIterator<Item = String>,
    {
        collect_extended(par_iter)
    }
}


impl FromParallelIterator<Box<str>> for String {
    fn from_par_iter<I>(par_iter: I) -> Self
    where
        I: IntoParallelIterator<Item = Box<str>>,
    {
        collect_extended(par_iter)
    }
}


impl<'a> FromParallelIterator<Cow<'a, str>> for String {
    fn from_par_iter<I>(par_iter: I) -> Self
    where
        I: IntoParallelIterator<Item = Cow<'a, str>>,
    {
        collect_extended(par_iter)
    }
}






impl<'a, C: ?Sized, T> FromParallelIterator<T> for Cow<'a, C>
where
    C: ToOwned,
    C::Owned: FromParallelIterator<T>,
    T: Send,
{
    fn from_par_iter<I>(par_iter: I) -> Self
    where
        I: IntoParallelIterator<Item = T>,
    {
        Cow::Owned(C::Owned::from_par_iter(par_iter))
    }
}
















impl FromParallelIterator<()> for () {
    fn from_par_iter<I>(par_iter: I) -> Self
    where
        I: IntoParallelIterator<Item = ()>,
    {
        par_iter.into_par_iter().drive_unindexed(NoopConsumer)
    }
}
