% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{corn_nitrogen_df}
\alias{corn_nitrogen_df}
\title{Argentina Corn Yield & Nitrogen Data}
\format{
A data frame with 3443 observations and 9 variables:
\describe{
  \item{year}{Integer indicating the year of observation}
  \item{lat}{Numeric vector of latitude coordinates}
  \item{long}{Numeric vector of longitude coordinates}
  \item{yield}{Numeric vector representing corn yield}
  \item{nitro}{Numeric vector representing nitrogen application level}
  \item{topo}{Factor with 4 levels indicating topographic classification}
  \item{bv}{Numeric vector representing block variance}
  \item{rep}{Factor with 3 levels indicating replication blocks}
  \item{nf}{Factor with 6 levels indicating nitrogen field treatments}
}
}
\source{
Data taken from the agridat package version 1.24
}
\usage{
data(corn_nitrogen_df)
}
\description{
This dataset, corn_nitrogen_df, is a data frame containing yield monitor data from a corn field in Argentina.
It includes information on yield response to varying nitrogen application levels, along with spatial coordinates,
topographic classification, and block structure for the experimental design.
}
\details{
The dataset name has been kept as 'corn_nitrogen_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ArgentinAPI package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
