% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CCD_original.R
\name{CCD_original}
\alias{CCD_original}
\title{Central Composite Designs (CCD) with original levels}
\usage{
CCD_original(v, type, min_L, max_L, randomization = FALSE, variance = FALSE)
}
\arguments{
\item{v}{Number of input factors, v(>2)}

\item{type}{Type of central composite design i.e.  ccc or cci or ccf. "ccc" is for Central Composite Circumscribed designs, "cci" is for Central Composite Inscribed designs and "ccf" is for Central Composite Face Centered designs}

\item{min_L}{A vector of minimum levels of the factors}

\item{max_L}{A vector of maximum levels of the factors}

\item{randomization}{It is for generating the randomized layout of the design. It takes either TRUE or FALSE  and by default, it is set to FALSE}

\item{variance}{This is for generating the moment matrix and prediction variance of the design based on a second order model. It gives unique prediction variance along with its frequencies. It takes either TRUE or FALSE  and by default, it is set to FALSE}
}
\value{
Central Composite Designs (CCD) for a given number of input factors (v) with original levels
}
\description{
This function generates Central Composite Designs (CCD) with original levels along with coded levels for a given number of input factors (v). The CCD constitute  combinations of factorial points, axial points and center points. Three types of CCDs can be generated using this function  i.e.  ccc or cci or ccf. "ccc" is for Central Composite Circumscribed designs, "cci" is for Central Composite Inscribed designs and "ccf" is for Central Composite Face Centered designs. It gives the randomized layout of the design along with the moment  matrix and prediction variance.
}
\note{
Here, the factorial portion consists of 2^v (full factorial) combinations and there is no upper limit for the number of input factors,v (>2). To get a CCD with smaller runs,  one may use fractional factorial (of resolution V) in place of full factorial.
}
\examples{

library(AsymmetricSORDs)
CCD_original(5,'ccc',c(10,15,20,25,30),c(15,20,25,30,35),FALSE,FALSE)

}
\references{
1) G.E.P. Box and K.B. Wilson (1951)." On the experimental attainment of optimum conditions".

2) M. Hemavathi, Shashi Shekhar, Eldho Varghese, Seema Jaggi, Bikas Sinha & Nripes Kumar Mandal (2022)<DOI: 10.1080/03610926.2021.1944213>. "Theoretical developments in response surface designs: an informative review and further thoughts".
}
