% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_repsandsenate.R
\name{get_reps_senate}
\alias{get_reps_senate}
\title{Generate datasets for House of Representative and Senate members service dates.}
\usage{
get_reps_senate(x)
}
\arguments{
\item{x}{A character string used to request a printout of the request code arguments,
*see Request Codes* below, or one of three prepared datasets.}
}
\value{
A console printout of a tibble containing arguments to be used with the function,
or the requested dataset using \code{x} assigned to a user created variable.
}
\description{
`get_reps_senate()` generates a dataset for members' service time for
the Australian House of Representatives, the Australian Senate, or a joined dataset
containing values for both the HoR and Senate. Additionally, will produce a set of
arguments that can be used as request codes for the individual datasets.
}
\details{
There are four request codes: `reps_senate`, `reps`, `senate` and `codes`.

The specifics of these are:

- `reps_senate` - generates a dataset of HoRs and Senate members;
- `reps` - generates a dataset of HoRs members;
- `senate` - generates a dataset of Senate members; and
- `codes` - returns a tibble of codes used to request data.

An incorrect request code (an argument not associated with a dataset or non-character string argument)
will stop function processes and return an error message.
}
\examples{
\dontrun{
# Generate a printout of the arguments.
get_reps_senate("codes")

# Generate combined HoR and Senate dataset.
reps_senate <- get_reps_senate("reps_senate")

# Preview dataset.
head(reps_senate)

# Generate only HoR dataset.
reps <- get_reps_senate("reps")

# Preview dataset.
head(reps)
}

}
