% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{Plot.ShapImportance}
\alias{Plot.ShapImportance}
\title{Plot.ShapImportance}
\usage{
Plot.ShapImportance(
  dt,
  PreAgg = FALSE,
  AggMethod = "meanabs",
  YVar = NULL,
  GroupVar = NULL,
  FacetRows = 1,
  FacetCols = 1,
  FacetLevels = NULL,
  NumberBins = 21,
  NumLevels_X = 33,
  NumLevels_Y = 33,
  Height = NULL,
  Width = NULL,
  Title = "Shap Importance",
  ShowLabels = FALSE,
  Title.YAxis = NULL,
  Title.XAxis = NULL,
  EchartsTheme = "dark",
  TextColor = "white",
  Debug = FALSE
)
}
\arguments{
\item{dt}{source data.table}

\item{PreAgg}{logical}

\item{AggMethod}{"mean", "median", "sum", "sd", "skewness","kurtosis", "coeffvar", "meanabs", "medianabs", "sumabs", "sdabs", "skewnessabs", "kurtosisabs", "CoeffVarabs"}

\item{YVar}{Names of shap columns}

\item{GroupVar}{Name of by variable}

\item{FacetRows}{Defaults to 1 which causes no faceting to occur vertically. Otherwise, supply a numeric value for the number of output grid rows}

\item{FacetCols}{Defaults to 1 which causes no faceting to occur horizontally. Otherwise, supply a numeric value for the number of output grid columns}

\item{FacetLevels}{Faceting rows x columns is the max number of levels allowed in a grid. If your GroupVar has more you can supply the levels to display.}

\item{NumberBins}{= 21}

\item{NumLevels_X}{= 20}

\item{NumLevels_Y}{= 20}

\item{Height}{"400px"}

\item{Width}{"200px"}

\item{Title}{"Heatmap"}

\item{ShowLabels}{character}

\item{Title.YAxis}{character}

\item{Title.XAxis}{character}

\item{EchartsTheme}{"dark-blue"}

\item{TextColor}{character}

\item{Debug}{= FALSE}
}
\value{
plot
}
\description{
Plot.ShapImportance variable importance
}
\seealso{
Other Model Evaluation: 
\code{\link{Plot.BinaryMetrics}()},
\code{\link{Plot.Calibration.Box}()},
\code{\link{Plot.Calibration.Line}()},
\code{\link{Plot.ConfusionMatrix}()},
\code{\link{Plot.Gains}()},
\code{\link{Plot.Lift}()},
\code{\link{Plot.PartialDependence.Box}()},
\code{\link{Plot.PartialDependence.HeatMap}()},
\code{\link{Plot.PartialDependence.Line}()},
\code{\link{Plot.ROC}()},
\code{\link{Plot.Residuals.Histogram}()},
\code{\link{Plot.Residuals.Scatter}()},
\code{\link{Plot.VariableImportance}()}
}
\author{
Adrian Antico
}
\concept{Model Evaluation}
