% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_cosmosdb.R
\docType{class}
\name{az_cosmosdb}
\alias{az_cosmosdb}
\title{Azure Cosmos DB account class}
\description{
Class representing an Azure Cosmos DB account. For working with the data inside the account, see \link{cosmos_endpoint} and \link{cosmos_database}.
}
\section{Methods}{

The following methods are available, in addition to those provided by the \link[AzureRMR:az_resource]{AzureRMR::az_resource} class:
\itemize{
\item \verb{list_keys(read_only=FALSE}): Return the access keys for this account.
\item \code{regen_key(kind)}: Regenerate (change) an access key. \code{kind} should be one of "primary", "secondary", "primaryReadonly" or "secondaryReadonly".
\item \code{get_endpoint(interface, ...)}: Return a default endpoint object for interacting with the data. See 'Endpoints' below.
\item \code{get_sql_endpoint(key, key_type)}: Return an object representing the core (SQL) endpoint of the account.
\item \code{get_table_endpoint(key)}: Return an object representing the table storage endpoint of the account.
\item \code{get_mongo_endpoint(collection, key, mongo_options)}: Return an object representing the MongoDB enpoint of the account.
}
}

\section{Details}{

Initializing a new object of this class can either retrieve an existing Cosmos DB resource, or create a new resource on the host. Generally, the best way to initialize an object is via the \code{get_cosmosdb_account} or \code{create_cosmosdb_account} methods of the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} class, which handle the details automatically.
}

\section{Endpoints}{

Azure Cosmos DB provides multiple APIs for accessing the data stored within the account. You choose at account creation the API that you want to use: core (SQL), table storage, Mongo DB, Apache Cassandra, or Gremlin. The following methods allow you to create an endpoint object corresponding to these APIs.
\itemize{
\item \code{get_endpoint(interface=NULL, ...)}: Return an endpoint object for interacting with the data. The default \code{interface=NULL} will choose the interface that you selected at account creation. Otherwise, set \code{interface} to one of "sql", "table", "mongo", "cassandra" or "gremlin" to create an endpoint object for that API. It's an error to select an interface that the Cosmos DB account doesn't actually provide.
\item \code{get_sql_endpoint(key, key_type=c("master", "resource"))}: Return an endpoint object for the core (SQL) API, of class \link{cosmos_endpoint}. A master key provides full access to all the data in the account; a resource key provides access only to a chosen subset of the data.
\item \code{get_table_endpoint(key)}: Return an endpoint object for the table storage API, of class \link[AzureTableStor:table_endpoint]{AzureTableStor::table_endpoint}.
\item \code{get_mongo_endpoint(key, mongo_options)}: Return an endpoint object for the MongoDB API, of class \link{cosmos_mongo_endpoint}. \code{mongo_options} should be an optional named list of parameters to set in the connection string.
}

Note that AzureCosmosR provides a client framework only for the SQL API. To use the table storage API, you will also need the AzureTableStor package, and to use the MongoDB API, you will need the mongolite package. Currently, the Cassandra and Gremlin APIs are not supported.

As an alternative to AzureCosmosR, you can also use the ODBC protocol to interface with the SQL API. By installing a suitable ODBC driver, you can then talk to Cosmos DB in a manner similar to other SQL databases. An advantage of the ODBC interface is that it fully supports cross-partition queries, unlike the REST API. A disadvantage is that it does not support nested document fields; functions like \code{array_contains()} cannot be used, and attempts to reference arrays and objects may return incorrect results.
}

\seealso{
\link{get_cosmosdb_account}, \link{create_cosmosdb_account}, \link{delete_cosmosdb_account}

\link{cosmos_endpoint}, \link{cosmos_database}, \link{cosmos_container}, \link{query_documents}, \link{cosmos_mongo_endpoint}, \link[AzureTableStor:table_endpoint]{AzureTableStor::table_endpoint}, \link[mongolite:mongo]{mongolite::mongo}
}
