% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk.R
\name{bulk_delete}
\alias{bulk_delete}
\alias{bulk_delete.cosmos_container}
\title{Delete a set of documents from an Azure Cosmos DB container}
\usage{
bulk_delete(container, ...)

\method{bulk_delete}{cosmos_container}(
  container,
  query,
  partition_key,
  procname = "_AzureCosmosR_bulkDelete",
  headers = list(),
  ...
)
}
\arguments{
\item{container}{A Cosmos DB container object, as obtained by \code{get_cosmos_container} or \code{create_cosmos_container}.}

\item{query}{A query specifying which documents to delete.}

\item{partition_key}{Optionally, limit the deletion only to documents with this key value.}

\item{procname}{The stored procedure name to use for the server-side import code. Change this if, for some reason, the default name is taken.}

\item{headers, ...}{Optional arguments passed to lower-level functions.}
}
\value{
The number of rows deleted.
}
\description{
Delete a set of documents from an Azure Cosmos DB container
}
\details{
This is a convenience function to delete multiple documents from a container. It works by creating a stored procedure and then calling it with the supplied query as a parameter. This function is not meant for production use.
}
\examples{
\dontrun{

endp <- cosmos_endpoint("https://myaccount.documents.azure.com:443/", key="mykey")
db <- get_cosmos_database(endp, "mydatabase")
cont <- create_cosmos_container(db, "mycontainer", partition_key="sex")

 # importing the Star Wars data from dplyr
bulk_import(cont, dplyr::starwars)

# deleting a subset of documents
bulk_delete(cont, "select * from mycontainer c where c.gender = 'masculine'")

# deleting documents for a specific partition key value
bulk_delete(cont, "select * from mycontainer", partition_key="male")

# deleting all documents
bulk_delete(cont, "select * from mycontainer")

}
}
\seealso{
\link{bulk_import}, \link{cosmos_container}
}
