% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ListCAT.R
\name{ListCAT}
\alias{ListCAT}
\title{List Critical Accumulation Table}
\usage{
ListCAT(ParamFile)
}
\arguments{
\item{ParamFile}{character string; the file name and path of the parameter
file.}
}
\value{
A \code{data.frame} object with the CAT table in the given parameter
  file. Columns include:
\describe{
   \item{\code{Num}}{the number or index in the table}
   \item{\code{`CA (nmol/gw)`}}{the critical accumulation in units of
     nmol/gw}
   \item{\code{Species}}{species name or CA significance, such as HC5 or
     FAV}
   \item{\code{`Test Type`}}{acute or chronic}
   \item{\code{Duration}}{test duration (e.g., 48 h)}
   \item{\code{Lifestage}}{age or size of the organisms}
   \item{\code{Endpoint}}{toxicity endpoint (e.g., mortality, reproduction)}
   \item{\code{Quantifier}}{endpoint quantifier or effect level (e.g., LC50,
     EC10, NOEC)}
   \item{\code{References}}{citations of sources with the toxicity data that
     went into calculating the CA, or the citation of the HC5 or FAV}
   \item{\code{Miscellanous}}{other notes or comments (e.g., number of data
     points or methods of calculating)}
}
}
\description{
List out the critical accumulation table for the user to allow them to pick
which CAT number they should specify for a toxicity run where the critical
value is coming from the table in the parameter file.
}
\examples{
mypfile = system.file("extdata", "ParameterFiles", "Cu_full_organic.dat4",
                      package = "BLMEngineInR",
                      mustWork = TRUE)
ListCAT(ParamFile = mypfile)
}
