% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BLRPM.R
\name{TS.acc}
\alias{TS.acc}
\title{Accumulation of a time series}
\usage{
TS.acc(x,acc.val)
}
\arguments{
\item{x}{\code{vector} of a time series}

\item{acc.val}{\code{value} specifying the accumulation level, minimum value is 2}
}
\value{
x.acc \code{TS.acc} returns a \code{vector} of an accumulated time series
}
\description{
\code{TS.acc} accumulates a given time series \code{x} at a given accumulation level \code{acc.val}. Minimum value
for acc.val is 2 [unit time]
}
\examples{
x <- rgamma(1000,1)
x.2 <- TS.acc(x,acc.val=2)
}
\author{
Christoph Ritschel \email{christoph.ritschel@met.fu-berlin.de}
}

