% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BLRPM.R
\name{TS.stats}
\alias{TS.stats}
\title{calculating statistics of a time series needed for parameter estimation}
\usage{
TS.stats(x,acc.vals)
}
\arguments{
\item{x}{\code{vector} of a time series}

\item{acc.vals}{\code{vector} of accumulation levels, first value should be 1}
}
\value{
stats \code{TS.stats} returns a \code{vector} of statistics calculated at given accumulation levels
}
\description{
\code{TS.stats} calculates statistics of a given time series \code{x} at given accumulation
levels \code{acc.vals}. The calculated statistics are the mean of the first accumulation level,
the variance, auto-covariance lag-1 and the probability of zero rainfall of all given accumulation 
levels of the time series. These statistics are needed for estimating the BLRPM parameters.
}
\examples{
time.series <- rgamma(1000,shape=1)
statistics <- TS.stats(time.series,acc.vals=c(1,3,12,24)) 
}
\author{
Christoph Ritschel \email{christoph.ritschel@met.fu-berlin.de}
}

