% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lpz_dist}
\alias{lpz_dist}
\title{Distance between latent positions}
\usage{
lpz_dist(Z)
}
\arguments{
\item{Z}{Latent positions matrix. The matrix size must be \code{(n,k)}, where \code{n} and \code{k} denote respectively 
the number of nodes in the network and the latent space dimensionality.}
}
\value{
Matrix containing the negative square root of the Euclidean distances between latent positions
}
\description{
Compute the square root of the Euclidean distances between latent positions and 
return them with a negative sign.
}
\examples{
pos = matrix(rnorm(20), ncol=2)
lpz_dist(pos)
}
