% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMisc.R
\name{combine_ecdfs}
\alias{combine_ecdfs}
\title{Combine Two Distribution Functions}
\usage{
combine_ecdfs(y.seq, dflist, weights = NULL, ...)
}
\arguments{
\item{y.seq}{sequence of possible y values}

\item{dflist}{list of distribution functions to combine}

\item{weights}{a vector of weights to put on each distribution function;
if weights are not provided then equal weight is given to each
distribution function}

\item{...}{additional arguments that can be past to BMisc::make_dist}
}
\value{
ecdf
}
\description{
Combines two distribution functions with given weights by `weights`
}
\examples{
x <- rnorm(100)
y <- rnorm(100, 1, 1)
Fx <- ecdf(x)
Fy <- ecdf(y)
both <- combineDfs(seq(-2, 3, 0.1), list(Fx, Fy))
plot(Fx, col = "green")
plot(Fy, col = "blue", add = TRUE)
plot(both, add = TRUE)

}
