% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcondXA.R
\name{fcondXA}
\alias{fcondXA}
\title{Conditional density evaluation in the semiparametric model}
\usage{
fcondXA(x, distr, Tau, J, sigma)
}
\description{
This function evaluates a density path conditionally on a posterior
realization of the normalized measure.
}
\details{
For internal use.
}
\examples{

## The function is currently defined as
function(x, distr = 1, Tau, J, sigma) {
  pJ <- J / sum(J)
  K <- matrix(NA, nrow = length(Tau), ncol = length(x))
  for (i in seq(Tau)) {
    K[i, ] <- dk(x, distr = distr, mu = Tau[i], sigma = sigma)
  }
  fcondXA <- apply(K, 2, function(x) sum(x * pJ))
  return(fcondXA)
}
}
\keyword{internal}
