% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mult_exp_covar.R
\name{fit_mult_exp_covar}
\alias{fit_mult_exp_covar}
\title{Fit multiple models to data from two-arm trials with an exponentially distributed time-to-event endpoint and one predictor of the intercurrent event}
\usage{
fit_mult_exp_covar(dat_mult_trials, params, seed = 23)
}
\arguments{
\item{dat_mult_trials}{List generated by \code{sim_dat_mult_trials_exp_covar}.}

\item{params}{List of model parameters as supplied to \code{fit_single_exp_covar}.}

\item{seed}{Numeric value, seed for reproducibility.}
}
\value{
A list of objects generated by \code{fit_single_exp_covar}.
}
\description{
Fit multiple models to data from two-arm trials with an exponentially distributed time-to-event endpoint and one predictor of the intercurrent event
}
\examples{
d_params_covar <- list(
  n = 1000,        
  nt = 500,       
  prob_X1 = 0.4, 
  prob_ice_X1 = 0.5, 
  prob_ice_X0 = 0.2,
  fu_max = 48*7,
  prop_cens = 0.15,         
  T0T_rate = 0.2,     
  T0N_rate = 0.2,     
  T1T_rate = 0.15,     
  T1N_rate = 0.1
 )
dat_mult_trials <- sim_dat_mult_trials_exp_covar(
  n_iter = 2,
  params = d_params_covar 
)
m_params_covar <- list(
  tg = 48,
  p = 2, 
  prior_delta = matrix(
    c(0, 5, 0, 5),
    nrow = 2, byrow = TRUE),
  prior_0N = c(1.5, 5),
  prior_1N = c(1.5, 5),
  prior_0T = c(1.5, 5),
  prior_1T = c(1.5, 5),
  t_grid =  seq(7, 7 * 48, 7) / 30,
  chains = 2,
  n_iter = 3000,
  warmup = 1500,
  cores = 2,
  open_progress = FALSE,
  show_messages = TRUE
)
\donttest{
fit_multiple <- fit_mult_exp_covar(
  dat_mult_trials = dat_mult_trials,
  params = m_params_covar,
  seed = 12
)
lapply(fit_multiple, dim)
head(fit_multiple[[1]])
}

}
\seealso{
\code{\link[=sim_dat_mult_trials_exp_covar]{sim_dat_mult_trials_exp_covar()}}, \code{\link[=fit_single_exp_covar]{fit_single_exp_covar()}}, \code{\link[=fit_mult_exp_nocovar]{fit_mult_exp_nocovar()}}
}
