% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brace.R
\name{brace}
\alias{brace}
\title{Bias Reduction through Analysis of Competing Events}
\usage{
brace(
  ftime,
  fstatus,
  covs = NA,
  trt,
  failcode = 1,
  cencode = 0,
  PS = 0,
  B = 1000
)
}
\arguments{
\item{ftime}{vector of failure/censoring times}

\item{fstatus}{vector with a unique code for each failure type and a
separate code for censored observations (default is primary event = 1,
competing event = 2, censored = 0)}

\item{covs}{matrix (nobs x ncovs) of fixed covariates. If no covariates,
set covs = NA (default is NA)}

\item{trt}{vector of treatment indicator (1 for treatment group)}

\item{failcode}{code of fstatus that denotes the failure type of interest}

\item{cencode}{code of fstatus that denotes censored observations}

\item{PS}{whether to use propensity score method for adjusting the
confounding effect (1 for propensity score method, default is 0)}

\item{B}{bootstrap sample size for calculating the Confidence interval,
default is 1000}
}
\value{
a list of class \code{brace}, with components:
\item{$Summary}{summary table of BRACE method}
\item{$`BRACE HR Distribution`}{the estimated regression coefficients in
each bootstrap sample}
\item{$`Omega Estimate`}{estimate of relative hazards for
primary events vs. combined events}
\item{$Epsilon}{the estimated bias}
\item{$`Combined Endpoint Model`}{the regression model for combined events}
\item{$`Primary Endpoint Model`}{the regression model for primary events}
\item{$`Competing Endpoint Model`}{the regression model for competing events}
\item{$`Omega Curve`}{estimate of omega over time}
\item{$`Combined Endpoint Curve`}{survival curve for combined events}
\item{$`Primary Endpoint Curve`}{survival curve for primary events}
\item{$`Competing Endpoint Curve`}{survival curve for competing events}
}
\description{
\code{brace} is used to estimate the treatment effect with adjusted
confounders on the composite hazard
for primary or competing events, and adjust for bias from residual
confounding in non-randomized data by BRACE method
}
\examples{
nsims = 1; nobs = 1500
f = 0.5; g = 0.333; b = 8; w1 = w2 = 0.667
theta1 = 0.5; theta2 = 1; omegaplus = 1; k3 = 0.333
sim1 = gendat(nsims,nobs,f,g,b,w1,w2,omegaplus,theta1,theta2,k3)
ftime = sim1$time
fstatus = sim1$pfs_ci
covs = NA
trt = sim1$group
braceoutput = brace(ftime, fstatus, covs, trt, PS=0, B=10)

nsims = 1; nobs = 1500
f1 = f2 = 0.5; g = 0.333; b1 = 8; b2 = 4; w1 = w2 = 0.667
theta1 = 0.5; theta2 = 1; omegaplus = 1; k3 = 0.333
sim1 = gendat2(nsims,nobs,f1,f2,g,b1,b2,w1,w2,omegaplus,theta1,theta2,k3)
ftime = sim1$time
fstatus = sim1$pfs_ci
covs = sim1$factor2
trt = sim1$group
braceoutput = brace(ftime, fstatus, covs, trt, PS=1, B=10)
}
\references{
Williamson, Casey W., et al. "Bias Reduction through Analysis of
Competing Events (BRACE) Correction to Address Cancer Treatment Selection
Bias in Observational Data." Clinical Cancer Research 28.9 (2022): 1832-1840.
}
