% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdata_generator.R
\name{bdata_generator}
\alias{bdata_generator}
\title{Data Generation Function for Binomial RDT Design}
\usage{
bdata_generator(
  Cf,
  Cv,
  nvec,
  G,
  Cw,
  N,
  Rvec,
  cvec,
  pi,
  par = all(),
  option = c("optimal"),
  thres_CR
)
}
\arguments{
\item{Cf}{Fixed costs of RDT}

\item{Cv}{Variable unit costs of RDT}

\item{nvec}{Vector of test sample size}

\item{G}{Reliabilty growth cost}

\item{Cw}{Average cost per warranty claim}

\item{N}{Sales volume}

\item{Rvec}{Vector of lower level reliability requirements}

\item{cvec}{Vector of maximum allowable failures}

\item{pi}{Failure probability}

\item{par}{Specify which columns to return. Default is all columns.The columns include c('n', 'R', 'c', 'CR', 'AP',
'RDT Cost', 'RG Cost', 'RG Cost Expected',
'WS Cost', 'WS Failure Probability', 'WS Cost Expected',  'Overall Cost')}

\item{option}{Options to get different datasets. Default is 'optimal'.
If option = 'all', get all test plans data for all combinations of n, c, R;
If option = 'optimal', get test plans data with optimal test sample size for every combination of c, R.}

\item{thres_CR}{Threshold (acceptable level) of consumer's risk}
}
\value{
Matrix of the dataset
}
\description{
Define the function to generate the dataset based on the design settings (for Binomial RDT).
}
\examples{
\donttest{
nvec <- seq(0, 10, 1)
Rvec <- seq(0.8, 0.85, 0.01)
cvec <- seq(0, 2, 1)
pi <- pi_MCSim_beta(M = 5000, seed = 10, a = 1, b = 1)
bdata_generator(Cf = 10, Cv = 10, nvec = nvec, G = 10000, Cw = 10,
N = 100, Rvec = Rvec, cvec = cvec, pi = pi,
par = c('n', 'R', 'c', 'CR', 'AP'), option = c("optimal"), thres_CR = 0.05)
}
}
\seealso{
\code{\link{boptimal_cost}} for getting the optial test plan with minimum overall cost;
\code{\link{boptimal_n}} for getting the optial test sample size;
}
