% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boptimal_cost.R
\name{boptimal_cost}
\alias{boptimal_cost}
\title{Optimal Test Plans with Minimum Expected Overall Costs in Binomial RDT Design}
\usage{
boptimal_cost(Cf, Cv, G, Cw, N, Rvec, cvec, pi, thres_CR)
}
\arguments{
\item{Cf}{Fixed costs of RDT}

\item{Cv}{Variable unit costs of RDT}

\item{G}{Reliabilty growth cost}

\item{Cw}{Average cost per warranty claim}

\item{N}{Sales volume}

\item{Rvec}{Vector of lower level reliability requirements}

\item{cvec}{Vector of maximum allowable failures}

\item{pi}{Failure probability}

\item{thres_CR}{Threshold (acceptable level) of consumer's risk}
}
\value{
Vector of optimal test plan parameters, acceptance probabiltiy and cost
}
\description{
Define the optimal function to find the optimal test plans with minimum expected overall costs (for binomial RDT).
}
\examples{
\donttest{
Rvec <- seq(0.8, 0.85, 0.01)
cvec <- seq(0, 2, 1)
pi <- pi_MCSim_beta(M = 5000, seed = 10, a = 1, b = 1)
boptimal_cost(Cf = 10, Cv = 10, G = 100, Cw = 10,
N = 100, Rvec = Rvec, cvec = cvec, pi = pi, thres_CR = 0.5);
}
}
\seealso{
\code{\link{boptimal_n}} for getting the optial test sample size;
\code{\link{bdata_generator}} for generating optimal test plans dataset;
}
