% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findCells.R
\name{findCells}
\alias{findCells}
\title{Find cell type proportions from bulk gene expression data using marker genes.}
\usage{
findCells(inputMat, markers, nMarker = 50, method = "SVD", scale = TRUE)
}
\arguments{
\item{inputMat}{Numeric gene expression data frame or matrix, with rownames corresponding to gene names, some of which are marker genes, and columns corresponding to samples.}

\item{markers}{Data frame with marker genes in one column (named "marker") and the cell type that that gene symbol corresponds to in another column (named "cell").}

\item{nMarker}{The number of marker genes (that are present in your expression data set) to use in estimating the surrogate cell type proportion variable for each cell type.}

\item{method}{To estimate the cell type proportions, can either use PCA or SVD.}

\item{scale}{Whether or not to scale the gene expression data from each marker gene prior to using it as an input for dimension reduction.}
}
\value{
A sample-by-cell type matrix of estimate cell type proportion variables.
}
\description{
Input a gene expression matrix and your own data frame of marker genes, and this function will estimate cell type proportions in your data set using one of the SVD or PCA dimension reduction approaches.
}
\examples{
\donttest{
cell_type_proportions = findCells(aba_marker_expression,
 markers = markers_df_brain, nMarker = 10)
str(cell_type_proportions)
}
}
\references{
Chikina M, Zaslavsky E, Sealfon SC. CellCODE: a robust latent variable approach to differential expression analysis for heterogeneous cell populations. Bioinformatics. 2015;31(10):1584-91.
}
