% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Heat}
\alias{Heat}
\title{Primary heating sources of homes on indian reservations versus all
households}
\format{
A data frame/tibble with 301 observations on two variables
\describe{ 
\item{fuel}{a factor with levels \code{Utility gas},
\code{LP bottled gas}, \code{Electricity}, \code{Fuel oil}, \code{Wood}, and
\code{Other}} 
\item{location}{a factor with levels \code{American Indians on reservation},
 \code{All U.S. households}, and \code{American Indians not on reservations}} 
}
}
\source{
Bureau of the Census, \emph{Housing of the American Indians on Reservations},
Statistical Brief 95-11, April 1995.
}
\usage{
Heat
}
\description{
Data for Exercise 1.29
}
\examples{

T1 <- xtabs(~ fuel + location, data = Heat)
T1
barplot(t(T1), beside = TRUE, legend = TRUE)

\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Heat, aes(x = fuel, fill = location)) + 
           geom_bar(position = "dodge") + 
           labs(y = "percent") + 
           theme_bw() + 
           theme(axis.text.x = element_text(angle = 30, hjust = 1)) 
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
