% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Stress}
\alias{Stress}
\title{Short-term memory test scores on 12 subjects before and after a stressful
situation}
\format{
A data frame/tibble with 12 observations on two variables
\describe{ 
\item{prestress}{short term memory score before being exposed to a stressful situation}
\item{poststress}{short term memory score after being exposed to a stressful situation} 
}
}
\usage{
Stress
}
\description{
Data for Example 7.20
}
\examples{

diff <- Stress$prestress - Stress$poststress
qqnorm(diff)
qqline(diff)
t.test(diff)
\dontrun{
wilcox.test(Pair(Stress$prestress, Stress$poststress)~1, data = Stress)
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
