% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Undergrad}
\alias{Undergrad}
\title{Data set describing a sample of undergraduate students}
\format{
A data frame/tibble with 100 observations on six variables
\describe{ 
\item{gender}{character variable with values \code{Female} and \code{Male}} 
\item{major}{college major}
\item{class}{college year group classification} 
\item{gpa}{grade point average}
\item{sat}{Scholastic Assessment Test score} 
\item{drops}{number of courses dropped}
}
}
\usage{
Undergrad
}
\description{
Data for Exercise 1.15
}
\examples{

stripchart(gpa ~ class, data = Undergrad, method = "stack", 
col = c("blue","red","green","lightblue"),
pch = 19, main = "GPA versus Class")
stripchart(gpa ~ gender, data = Undergrad, method = "stack", 
           col = c("red", "blue"), pch = 19,
           main = "GPA versus Gender")
           stripchart(sat ~ drops, data = Undergrad, method = "stack", 
           col = c("blue", "red", "green", "lightblue"),
           pch = 19, main = "SAT versus Drops")
stripchart(drops ~ gender, data = Undergrad, method = "stack", 
           col = c("red", "blue"), pch = 19, main = "Drops versus Gender")
 \dontrun{
 library(ggplot2)
 ggplot2::ggplot(data = Undergrad, aes(x = sat, y = drops, fill = factor(drops))) + 
            facet_grid(drops ~.) +
            geom_dotplot() +
            guides(fill = FALSE)
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
