% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/94_logLik.R
\name{WAIC.bvar}
\alias{WAIC.bvar}
\alias{WAIC}
\alias{WAIC.default}
\title{Widely applicable information criterion (WAIC) for Bayesian VARs}
\usage{
\method{WAIC}{bvar}(x, n_thin = 1L, ...)

WAIC(x, ...)

\method{WAIC}{default}(x, ...)
}
\arguments{
\item{x}{A \code{bvar} object, obtained from \code{\link{bvar}}.}

\item{n_thin}{Integer scalar. Every \emph{n_thin}'th draw in \emph{x} is used
to calculate, others are dropped.}

\item{...}{Not used.}
}
\value{
Returns a numerical value.
}
\description{
Calculates the widely applicable (or Watanabe-Akaike) information criterion
(Watanabe, 2010) for VAR models generated with \code{\link{bvar}}. The
result equals \deqn{-2 (\text{lppd} - \text{pWAIC}}, where 'lppd' is the
log pointwise predictive density, and 'pWAIC' is the effective number of
parameters.
}
\examples{
\donttest{
# Access a subset of the fred_qd dataset
data <- fred_qd[, c("CPIAUCSL", "UNRATE", "FEDFUNDS")]
# Transform it to be stationary
data <- fred_transform(data, codes = c(5, 5, 1), lag = 4)

# Estimate a BVAR using one lag, default settings and very few draws
x <- bvar(data, lags = 1, n_draw = 600L, n_burn = 100L, verbose = FALSE)

# Calculate the log-likelihood
WAIC(x)
}
}
\references{
Watanabe, S. (2010) Asymptotic Equivalence of Bayes Cross Validation and
  Widely Applicable Information Criterion in Singular Learning Theory.
  \emph{Journal of Machine Learning Research}, \bold{11}, 3571-3594.

  Kuschnig, N. and Vashold, L. (2021) BVAR: Bayesian Vector Autoregressions
  with Hierarchical Prior Selection in R.
  \emph{Journal of Statistical Software}, \bold{14}, 1-27,
  \doi{10.18637/jss.v100.i14}.
}
\seealso{
\code{\link{bvar}}
}
\keyword{BVAR}
\keyword{analysis}
