% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment.R
\name{augment.bvar}
\alias{augment.bvar}
\alias{augment.bvar_fcast}
\alias{augment.bvar_irf}
\title{Augment BVAR outputs and convert into a tibble}
\usage{
\method{augment}{bvar}(x, conf_bands = 0.16, ...)

\method{augment}{bvar_fcast}(x, t_back = 0L, ...)

\method{augment}{bvar_irf}(x, ...)
}
\arguments{
\item{x}{A \code{bvar} or derived object to turn into a tibble.}

\item{conf_bands}{Numeric vector. Credible intervals of coefficients to
include in the tibble.}

\item{...}{Not used.}

\item{t_back}{Integer scalar. Whether to include actual datapoints in the
tidied forecast.}
}
\value{
Returns a \code{\link[tibble]{tibble}} with relevant information;
quantiles can be found in the columns.
}
\description{
Turn the outputs of a Bayesian VAR (see \code{\link[BVAR]{bvar}}) into a
an augmented tibble. Methods are available for \code{bvar} objects (will
yield coefficients and their quantiles), \code{bvar_fcast} objects (with
predictions, their quantiles and optionally real datapoints), and
\code{bvar_irf} objects (with impulse responses).
}
\examples{
\donttest{
# Access a subset of the fred_qd dataset
data <- fred_qd[, c("CPIAUCSL", "UNRATE", "FEDFUNDS")]
# Transform it to be stationary
data <- fred_transform(data, codes = c(5, 5, 1), lag = 4)

# Estimate a BVAR using one lag, default settings and very few draws
x <- bvar(data, lags = 1, n_draw = 1000L, n_burn = 200L, verbose = FALSE)

# Create tibbles from the outputs
augment(x)
augment(irf(x))
augment(predict(x))
}
}
