% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/durations.hpd.R
\name{durations.hpd}
\alias{durations.hpd}
\title{durations.hpd}
\usage{
durations.hpd(support,fn.eval,start,stop,target=0.90,tol=0.01)
}
\arguments{
\item{support}{x-axis values}

\item{fn.eval}{function values at x-axis points}

\item{start}{starting point in the vectors}

\item{stop}{stoppng point in the vectors}

\item{target}{Desired X Level}

\item{tol}{Tolerance for round-off}
}
\description{
Simple HPD calculator from Chapter 2 (page 51, 2nd Edition).
}
\examples{
\dontrun{
  get("cabinet.duration")
  ruler <- seq(0.45,0.75,length=10000)
  g.vals <- round(dgamma(ruler,shape=sum(cabinet.duration$N), 
                  rate=sum(cabinet.duration$N*cabinet.duration$dur)),2)
  start.point  <- 1000; stop.point <- length(g.vals)
  durations.hpd(ruler,g.vals,start.point,stop.point)
}

}
\author{
Jeff Gill
}
