% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/union.R
\name{union}
\alias{union}
\alias{union.TidySet}
\title{Join sets}
\usage{
union(object, ...)

\method{union}{TidySet}(
  object,
  sets,
  name = NULL,
  FUN = "max",
  keep = FALSE,
  keep_relations = keep,
  keep_elements = keep,
  keep_sets = keep,
  ...
)
}
\arguments{
\item{object}{A TidySet object.}

\item{...}{Other named arguments passed to \code{FUN}.}

\item{sets}{The name of the sets to be used.}

\item{name}{The name of the new set. By defaults joins the sets with an
\ifelse{latex}{\out{$\cap$}}{\ifelse{html}{\out{&cap;}}{}}.}

\item{FUN}{A function to be applied when performing the union.
The standard union is the "max" function, but you can provide any other
function that given a numeric vector returns a single number.}

\item{keep}{A logical value if you want to keep.}

\item{keep_relations}{A logical value if you wan to keep old relations.}

\item{keep_elements}{A logical value if you wan to keep old elements.}

\item{keep_sets}{A logical value if you wan to keep old sets.}
}
\value{
A \code{TidySet} object.
}
\description{
Given a TidySet merges several sets into the new one using the logic
defined on FUN.
}
\details{
The default uses the \code{max} function following the \href{https://en.wikipedia.org/wiki/Fuzzy_set_operations}{standard fuzzy definition}, but it can be
changed. See examples below.
}
\examples{
# Classical set
rel <- data.frame(
    sets = c(rep("A", 5), "B", "B"),
    elements = c(letters[seq_len(6)], "a")
)
TS <- tidySet(rel)
union(TS, c("B", "A"))
# Fuzzy set
rel <- data.frame(
    sets = c(rep("A", 5), "B", "B"),
    elements = c(letters[seq_len(6)], "a"),
    fuzzy = runif(7)
)
TS2 <- tidySet(rel)
# Standard default logic
union(TS2, c("B", "A"), "C")
# Probability logic
union(TS2, c("B", "A"), "C", FUN = union_probability)
}
\seealso{
\code{\link[=union_probability]{union_probability()}}

Other methods that create new sets: 
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{intersection}()},
\code{\link{subtract}()}

Other methods: 
\code{\link{TidySet-class}},
\code{\link{activate}()},
\code{\link{add_column}()},
\code{\link{add_relation}()},
\code{\link{arrange.TidySet}()},
\code{\link{cartesian}()},
\code{\link{complement}()},
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{element_size}()},
\code{\link{elements}()},
\code{\link{filter.TidySet}()},
\code{\link{group}()},
\code{\link{group_by.TidySet}()},
\code{\link{incidence}()},
\code{\link{intersection}()},
\code{\link{is.fuzzy}()},
\code{\link{is_nested}()},
\code{\link{move_to}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets}()},
\code{\link{name_sets<-}()},
\code{\link{power_set}()},
\code{\link{pull.TidySet}()},
\code{\link{relations}()},
\code{\link{remove_column}()},
\code{\link{remove_element}()},
\code{\link{remove_relation}()},
\code{\link{remove_set}()},
\code{\link{rename_elements}()},
\code{\link{rename_set}()},
\code{\link{select.TidySet}()},
\code{\link{set_size}()},
\code{\link{sets}()},
\code{\link{subtract}()}
}
\concept{methods}
\concept{methods that create new sets}
