% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PD_BPFhat.R
\name{PD_BPFhat}
\alias{PD_BPFhat}
\title{Two dimensional Bernstein polynomial}
\usage{
PD_BPFhat(coef, ages, years, pdbasis, by = 1)
}
\arguments{
\item{coef}{Bernstein polynomial coefficients.}

\item{ages}{Range of ages.}

\item{years}{Range of years.}

\item{pdbasis}{Partial differential Bernstein polynomial basis.}

\item{by}{1: partial differential by ages; 2: partial differential by years.}
}
\value{
Partial differential Bernstein polynomial given coefficients.
}
\description{
Given Bernstein polynomial coeffients to compute Fhat.
}
\examples{
coef <- runif(9)
ages <- 35:85
years <- 1988:2007
pdbasis <- PD_BPbasis(ages,years,10,N=1,by=1)
PD_BPFhat(coef,ages,years,pdbasis,by=1)
}
\seealso{
Other outer Bernstein polynomial: 
\code{\link{BPFhat}()}
}
\concept{outer Bernstein polynomial}
