% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_BrainMap.R
\name{UpdateTheta_BrainMap}
\alias{UpdateTheta_BrainMap}
\alias{UpdateTheta_BrainMap.spatial}
\alias{UpdateTheta_BrainMap.independent}
\title{Parameter Estimates in EM Algorithm for Bayesian brain map}
\usage{
UpdateTheta_BrainMap.spatial(
  prior_mean,
  prior_var,
  meshes,
  BOLD,
  theta,
  C_diag,
  H,
  Hinv,
  s0_vec,
  D,
  Dinv_s0,
  verbose = FALSE,
  return_MAP = FALSE,
  update = c("all", "kappa", "A")
)

UpdateTheta_BrainMap.independent(
  prior_mean,
  prior_var,
  BOLD,
  theta,
  C_diag,
  H,
  Hinv,
  update_nu0sq = TRUE,
  return_MAP = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{prior_mean}{(\eqn{V \times Q} matrix) mean maps for each network in prior}

\item{prior_var}{(\eqn{V \times Q} matrix) between-subject variance maps for each network in prior}

\item{meshes}{\code{NULL} for spatial independence model, otherwise a list of
objects of class "BrainMap_mesh" containing the triangular mesh (see
\code{\link{make_mesh}}) for each brain structure.}

\item{BOLD}{(\eqn{V \times Q} matrix) dimension-reduced fMRI data}

\item{theta}{(list) current parameter estimates}

\item{C_diag}{\eqn{(Qx1)} diagonal elements of residual covariance after dimension reduction}

\item{H, Hinv}{For dimension reduction}

\item{s0_vec}{Vectorized prior means}

\item{D}{Sparse diagonal matrix of prior standard deviations}

\item{Dinv_s0}{The inverse of D times s0_vec}

\item{verbose}{If \code{TRUE}, display progress of algorithm. Default: \code{FALSE}.}

\item{return_MAP}{If \code{TRUE}. return the posterior mean and precision of
the latent fields instead of the parameter estimates. Default: \code{FALSE}.}

\item{update}{Which parameters to update. Either \code{"all"}, \code{"A"} or \code{"kappa"}.}

\item{update_nu0sq}{For non-spatial model: updating \code{nu0sq} is recommended
if dimension reduction was not performed, and is not recommended if it was.}
}
\value{
An updated list of parameter estimates, theta, OR if
\code{return_MAP=TRUE}, the posterior mean and precision of the latent fields
}
\description{
Parameter Estimates in EM Algorithm for Bayesian brain map
}
