% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postK_mk.R
\name{postK_mk}
\alias{postK_mk}
\title{Marginal probability of K per bin}
\usage{
postK_mk(k, m0, w, M, Yn, sigma2n, cellsn, mk, Cr)
}
\arguments{
\item{k}{A scalar for the number of changes points in a cluster}

\item{m0}{A scalar for the number of positions available to define change-points positions}

\item{w}{A scalar representing the minimum number of points in each interval between two change points}

\item{M}{A scalar representing the number of points available for each data sequence}

\item{Yn}{A vector or matrix with data sequences for a cluster}

\item{sigma2n}{A vector with the variance of the data sequences in a cluster}

\item{cellsn}{A vector with the indices of the data sequences in a cluster}

\item{mk}{A matrix with all possible values to distribute between change points}

\item{Cr}{A scalar with the number of data sequences in a cluster}
}
\value{
`postK_mk` returns a numerical value representing the non-normalized probability for a given bin, given k, and a given cluster
}
\description{
Marginal probability of K per bin
}
\note{
This function is called within [postK()]. It should not be called alone.
}
\examples{
data(data)
M <- 50; k <- 0; w <- 10;
m0 <- M - 1 -(k+1)*w
for(k in 0:2){
mk <- RcppAlgos::permuteGeneral(0:m0, k + 1,
constraintFun = "sum",
comparisonFun = "==", limitConstraints = m0,
repetition = TRUE)}
out <- postK_mk(k = 0, m0 = m0, w = 10, M = 50, Yn = data[,c(1,2,4)],
 sigma2n = rep(0.05, 3), cellsn = c(1,2,4), mk = mk[1,], Cr = 3)
}
\seealso{
[postK()], [gibbs_alg()]
}
