% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastGPfit.R
\name{GP.create.cols}
\alias{GP.create.cols}
\title{Create 256 colors gradually transitioning from
Blue to Yellow to Red.}
\usage{
GP.create.cols(num = 256L)
}
\arguments{
\item{num}{A integer number to specify the number of colors to generate. The default value is 256.}
}
\value{
A vector of RGB colors
}
\description{
Create 256 colors gradually transitioning from
Blue to Yellow to Red.
}
\examples{
colors = GP.create.cols(101L)
require(graphics)
filled.contour(volcano,col=colors,nlevels=length(colors)-1,asp=1)
filled.contour(volcano,color.palette = GP.create.cols, nlevels=256, asp = 1)
}
\author{
Jian Kang <jiankang@umich.edu>
}
