% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{Estimate_MCMC_Growth}
\alias{Estimate_MCMC_Growth}
\title{Estimate_MCMC_Growth}
\usage{
Estimate_MCMC_Growth(
  data,
  Model = NULL,
  Linf = NULL,
  Linf.se = NULL,
  L0 = NULL,
  L0.se = NULL,
  k.max = NULL,
  sigma.max = NULL,
  iter = 10000,
  BurnIn = iter/2,
  n_cores = 1,
  controls = NULL,
  n.chains = 4,
  thin = 1,
  verbose = FALSE
)
}
\arguments{
\item{data}{A data.frame that contains columns named 'Age' and "Length'. The function can
detect columns with similar names. If age and length columns cannot be determined then
an error will occur. The dataset can have additional columns which will be ignored by
the function}

\item{Model}{Which growth model should be run? Must be one of "VB", "Gom" or "Log" for von
Bertalanffy, Gompertz or Logistic models, respectively}

\item{Linf}{The prior for asymptotic length. Must be in the same unit (i.e. cm or mm) as the data.
This should be based off of maximum size for the species.}

\item{Linf.se}{The prior for normally distributed standard error around
asymptotic length. Must be in the same unit (i.e. cm or mm) as the data. Cannot be zero.}

\item{L0}{The prior for length-at-birth. Must be in the same unit (i.e. cm or mm) as the data.
This should be based off of minimum size for the species.}

\item{L0.se}{The prior for normally distributed standard error around
length-at-birth. Must be in the same unit (i.e. cm or mm) as the data. Cannot be zero.}

\item{k.max}{The maximum value to consider for the growth completion parameter 'k'. In
the Gompertz and Logistic models, this parameter is often notated as 'g' instead of 'k'.}

\item{sigma.max}{The maximum value to consider for sigma. This is the variance around the
length-at-age residuals.}

\item{iter}{How many MCMC iterations should be run? Default is 10000 but fewer can be useful to
avoid longer run times when testing code or data}

\item{BurnIn}{The number of iterations at the beginning of each chain to discard ('Burn in') to
avoid biased values from starting values that do not resemble the target distribution.
Default is iter/2.}

\item{n_cores}{The number of cores to be used for parallel processing. It should be 1 core less than the
maximum number available.}

\item{controls}{A named list of parameters to control the rstan models behaviour.}

\item{n.chains}{Number of MCMC chains to be run. Default is 4.}

\item{thin}{The thinning of the MCMC simulations. Default is 1 which means no thinning occurs.
Thinning is generally only necessary for complicated models as it increases run time.}

\item{verbose}{TRUE or FALSE: flag indicating whether to print intermediate output from Stan on the console,
which might be helpful for model debugging.}
}
\value{
An object of class 'stanfit' from the rstan package.
}
\description{
A wrapper function that creates a Stan MCMC model using the rstan package.
    The data and priors provided are combined into an rstan model that estimates a length-at-age
    model with a normal distribution. Three different growth models can be used: a von Bertalanffy
    model, Gompertz model or a logistic model. The prior on Linf and L0 are normally distributed
    and determined through the user providing a mean and se for each parameter. The growth completion
    parameter for any model (k) has a uniform prior which only requires an upper bound with the
    lower bound set at zero. Sigma is the residual variance of the data around the model and
    is set up in the same manner as 'k'. The growth estimates in the model are truncated to
    remain above zero so negative growth cannot occur.
}
\examples{
\donttest{
# load example data
data("example_data")
## Biological info - lengths in mm
max_size <- 440
max_size_se <- 5
birth_size <- 0
birth_size_se <- 0.001 # an se cannot be zero

# Use the function to estimate the rstan model
fit <- Estimate_MCMC_Growth(data = example_data,
                            Model = "VB" ,
                            iter = 5000,
                            Linf = max_size,
                            Linf.se = max_size_se,
                            L0 = birth_size,
                            sigma.max = 100,
                            L0.se = birth_size_se,
                            k.max = 1,
                            n_cores = 1)
}
}
