% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converge_diag_fn.R
\name{converge_diag_fn}
\alias{converge_diag_fn}
\title{A function to check for overall convergence of fitted stochastic mortality models for monitoring purposes}
\usage{
converge_diag_fn(result, tol = 0.2, plot_gelman = FALSE, plot_geweke = FALSE)
}
\arguments{
\item{result}{object of type either "fit_result" or "BayesMoFo".}

\item{tol}{A numeric value between 0 and 1 specifying the tolerance percentage of the convergence diagnostics, i.e. if the proportion of convergence diagnostic checks/tests (either Gelman's or Heidel's) exceeds \code{tol}, warning messages will be triggered. Default is \code{tol=0.20}.}

\item{plot_gelman}{A logical value indicating whether to produce a plot of Gelman's R statistic, PSRF ("potential scale reduction factor") for visualisation.}

\item{plot_geweke}{A logical value indicating whether to produce a plot of Geweke's statistic for visualisation.}
}
\value{
A message of recommendations and (possibly) convergence diagnostics plots. Additionally, a list with components:
\describe{
\item{\code{gelman_diag}}{A \code{gelman.diag} object which is a list containing the estimated R statistic (PSRF) along with the upper confidence intervals, and also the multivariate PSRF (Brooks and Gelman, 1998). See Gelman and Rubin (1992) for more details.}
\item{\code{geweke_diag}}{A \code{geweke.diag} object which is a list containing the estimated Geweke's Z scores and the corresponding fractions used for equality of means test. See Geweke (1992) for more details.}
\item{\code{heidel_diag}}{A \code{heidel.diag} object which is a matrix containing results from both Stationarity and Half-width tests. See Heidelberger and Welch (1981), Heidelberger and Welch (1983) for more details.}
\item{\code{n}}{The total number of posterior samples (if more than one chain were generated, they are merged into one long chain).}
}
}
\description{
Compute several common MCMC convergence diagnostics of parameters fitted under stochastic mortality models using posterior samples stored in "fit_result" object.
}
\examples{
\donttest{
#load and prepare data
data("dxt_array_product");data("Ext_array_product")
death<-preparedata_fn(dxt_array_product,strat_name = c("ACI","DB","SCI"),ages=35:65)
expo<-preparedata_fn(Ext_array_product,strat_name = c("ACI","DB","SCI"),ages=35:65)

#fit any mortality model
runBayesMoFo_result<-runBayesMoFo(death=death,expo=expo,models="M1A",n_iter=1000,
  family="poisson",n.chain=5,thin=1)

#compute convergence diagnostics (with plots)
converge_runBayesMoFo_result<-converge_diag_fn(runBayesMoFo_result,
  plot_gelman=TRUE,plot_geweke=TRUE)

#Gelman's R (PSRF)
converge_runBayesMoFo_result$gelman_diag

#Geweke's Z statistics
converge_runBayesMoFo_result$geweke_diag$z

#Heidel's Stationary and Halfwidth Tests
converge_runBayesMoFo_result$heidel_diag
}
}
\references{
Andrew Gelman, Donald B. Rubin. (1992). "Inference from Iterative Simulation Using Multiple Sequences," Statistical Science, Statist. Sci. 7(4), 457-472. \doi{DOI: 10.1214/ss/1177011136}

Brooks, SP. and Gelman, A. (1998). General methods for monitoring convergence of iterative simulations. Journal of Computational and Graphical Statistics, 7, 434-455. \doi{https://doi.org/10.1080/10618600.1998.10474787}

Geweke, J. (1992) Evaluating the accuracy of sampling-based approaches to calculating posterior moments. In Bayesian Statistics 4 (ed JM Bernado, JO Berger, AP Dawid and AFM Smith). Clarendon Press, Oxford, UK. \doi{https://doi.org/10.21034/sr.148}

Heidelberger P and Welch PD. (1981). A spectral method for confidence interval generation and run length control in simulations. Comm. ACM. 24, 233-245. \doi{https://doi.org/10.1145/358598.358630}

Heidelberger P and Welch PD. (1983) Simulation run length control in the presence of an initial transient. Opns Res., 31, 1109-44. \doi{https://doi.org/10.1287/opre.31.6.1109}
}
\concept{PSRF}
\concept{convergence}
\keyword{bayesian}
\keyword{diagnostics}
\keyword{visualization}
