% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssdSig.R
\name{ssdSig}
\alias{ssdSig}
\title{Sample size determination for replication success based on
    significance}
\usage{
ssdSig(level, dprior, power)
}
\arguments{
\item{level}{Significance level for the replication effect estimate
(one-sided and in the same direction as the original effect estimate)}

\item{dprior}{Design prior object}

\item{power}{Desired probability of replication success}
}
\value{
Returns an object of class \code{"ssdRS"}. See \code{\link{ssd}} for
    details.
}
\description{
This function computes the standard error required to achieve
    replication success with a certain probability and based on statistical
    significance of the replication effect estimate.
}
\examples{
## specify design prior
to1 <- 2
so1 <- 0.5
dprior <- designPrior(to = to1, so = so1, tau = 0.1)
ssdSig(level = 0.025, dprior = dprior, power = 0.9)

}
\references{
Pawel, S., Consonni, G., and Held, L. (2022). Bayesian approaches to
designing replication studies. arXiv preprint.
\doi{10.48550/arXiv.2211.02552}
}
\author{
Samuel Pawel
}
