% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BFs.R
\name{BFslogOR}
\alias{BFslogOR}
\title{Sceptical Bayes factor for logOR effect sizes}
\usage{
BFslogOR(
  ao,
  bo,
  nTo = ao + bo,
  co,
  do,
  nCo = co + do,
  ar,
  br,
  nTr = ar + br,
  cr,
  dr,
  nCr = cr + dr,
  method = c("integration", "hypergeo")
)
}
\arguments{
\item{ao}{Number of cases in original study treatment group}

\item{bo}{Number of non-cases in original study treatment group}

\item{nTo}{Number of participants in original study treatment group (specify
alternatively to \code{b})}

\item{co}{Number of cases in original study control group}

\item{do}{Number of non-cases in original study control group}

\item{nCo}{Number of participants in original study control group (specify
alternatively to \code{d})}

\item{ar}{Number of cases in replication study treatment group}

\item{br}{Number of non-cases in replication study treatment group}

\item{nTr}{Number of participants in replication study treatment group
(specify alternatively to \code{b})}

\item{cr}{Number of cases in replication study control group}

\item{dr}{Number of non-cases in replication study control group}

\item{nCr}{Number of participants in replication study control group (specify
alternatively to \code{d})}

\item{method}{Method to compute posterior density. Either
\code{"integration"} (default) or \code{"hypergeo"}}
}
\value{
The sceptical Bayes factor \eqn{\mathrm{BF}_{\mathrm{S}}}{BF_S}.
\eqn{\mathrm{BF}_{\mathrm{S}} < 1}{BF_S < 1} indicates replication
success, the smaller the value of \eqn{\mathrm{BF}_{\mathrm{S}}}{BF_S}
the higher the degree of replication success. It is possible that the
result of the replication is so inconclusive that replication success
cannot be established at any level. In this case, the sceptical Bayes
factor does not exist and the function returns \code{NaN}.
}
\description{
Computes the sceptical Bayes factor for logOR effect sizes
}
\details{
This function computes the sceptical Bayes factor for log odds ratio
(logOR) effect sizes using an exact binomial likelihood for the data
instead of the normal approximation used in \code{\link{BFs}} (for
details, see Section 4 in Pawel and Held, 2022).
}
\examples{
data("SSRPexact")
balafoutas2012 <- subset(SSRPexact, study == "Balafoutas and Sutter (2012), Science")
with(balafoutas2012,
     BFslogOR(ao = ao, bo = bo, co = co, do = do, ar = ar, br = br, cr = cr, dr = dr))

}
\references{
Pawel, S. and Held, L. (2022). The sceptical Bayes factor for the
assessment of replication success. Journal of the Royal Statistical
Society Series B: Statistical Methodology, 84(3): 879-911.
\doi{10.1111/rssb.12491}
}
\seealso{
\code{\link{BFs}}, \code{\link{BFslogOR}}
}
\author{
Samuel Pawel
}
